/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyRequestPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.Module;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.Utilities;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;

public final class GrizzlyHttpContainer
extends HttpHandler
implements Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(GrizzlyHttpContainer.class.getName()), Level.FINEST);
    private static final CompletionHandler<Response> EMPTY_COMPLETION_HANDLER = new CompletionHandler<Response>(){

        public void cancelled() {
        }

        public void failed(Throwable throwable) {
        }

        public void completed(Response result) {
        }

        public void updated(Response result) {
        }
    };
    private volatile ApplicationHandler appHandler;
    private final ContainerLifecycleListener containerListener;

    GrizzlyHttpContainer(ApplicationHandler application) {
        this.appHandler = application;
        this.containerListener = ConfigHelper.getContainerLifecycleListener((ApplicationHandler)application);
        this.appHandler.registerAdditionalModules((Set)new HashSet<Module>(){
            {
                this.add(new GrizzlyModule());
            }
        });
    }

    public void start() {
        super.start();
        this.containerListener.onStartup((Container)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(final Request request, final Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response);
        try {
            logger.debugLog("GrizzlyHttpContaner.service(...) started", new Object[0]);
            URI baseUri = this.getBaseUri(request);
            ContainerRequest requestContext = new ContainerRequest(baseUri, this.getRequestUri(baseUri, request), request.getMethod().getMethodString(), this.getSecurityContext(request), (PropertiesDelegate)new GrizzlyRequestPropertiesDelegate(request));
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getHeaderNames()) {
                requestContext.headers(headerName, request.getHeaders(headerName));
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                public void initialize(ServiceLocator services) {
                    ((Ref)services.getService(new TypeLiteral<Ref<Request>>(){}.getType(), new Annotation[0])).set((Object)request);
                    ((Ref)services.getService(new TypeLiteral<Ref<Response>>(){}.getType(), new Annotation[0])).set((Object)response);
                }
            });
            this.appHandler.handle(requestContext);
        }
        finally {
            logger.debugLog("GrizzlyHttpContaner.service(...) finished", new Object[0]);
        }
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.appHandler.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler = new ApplicationHandler((Application)configuration.addModules(new Module[]{new GrizzlyModule()}));
        this.containerListener.onReload((Container)this);
    }

    public void destroy() {
        super.destroy();
        this.containerListener.onShutdown((Container)this);
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private URI getRequestUri(URI baseUri, Request grizzlyRequest) {
        String originalUri = UriBuilder.fromPath((String)grizzlyRequest.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString(Charsets.DEFAULT_CHARSET)).build(new Object[0]).toString();
        String queryString = grizzlyRequest.getQueryString();
        if (queryString != null) {
            originalUri = originalUri + "?" + queryString;
        }
        URI requestUri = baseUri.resolve(originalUri);
        return requestUri;
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final String name;
        private final Response grizzlyResponse;

        ResponseWriter(Response response) {
            this.grizzlyResponse = response;
            if (logger.isDebugLoggable()) {
                this.name = "ResponseWriter {id=" + UUID.randomUUID().toString() + ", grizzlyResponse=" + this.grizzlyResponse.hashCode() + '}';
                logger.debugLog("{0} - init", new Object[]{this.name});
            } else {
                this.name = "ResponseWriter";
            }
        }

        public String toString() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            try {
                if (this.grizzlyResponse.isSuspended()) {
                    this.grizzlyResponse.resume();
                }
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - commit() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - commit() called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                this.grizzlyResponse.cancel();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - cancel() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - cancel() called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                this.grizzlyResponse.suspend(timeOut, timeUnit, EMPTY_COMPLETION_HANDLER, new TimeoutHandler(){

                    public boolean onTimeout(Response response) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout((ContainerResponseWriter)ResponseWriter.this);
                        }
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                this.grizzlyResponse.getSuspendContext().setTimeout(timeOut, timeUnit);
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - setSuspendTimeout(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - setSuspendTimeout(...) called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            OutputStream outputStream;
            try {
                this.grizzlyResponse.setStatus(context.getStatus());
                this.grizzlyResponse.setContentLengthLong(contentLength);
                for (Map.Entry e : context.getStringHeaders().entrySet()) {
                    for (String value : (List)e.getValue()) {
                        this.grizzlyResponse.addHeader((String)e.getKey(), value);
                    }
                }
                outputStream = this.grizzlyResponse.getOutputStream();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
            return outputStream;
        }
    }

    private static class GrizzlyModule
    extends AbstractModule {
        private GrizzlyModule() {
        }

        protected void configure() {
            this.bind(BuilderHelper.link(GrizzlyRequestReferencingFactory.class).to(Request.class).in(PerLookup.class).buildFactory());
            this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<Request>>(){}.getType()}));
            this.bind(BuilderHelper.link(GrizzlyResponseReferencingFactory.class).to(Response.class).in(PerLookup.class).buildFactory());
            this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<Response>>(){}.getType()}));
        }
    }

    private static class GrizzlyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public GrizzlyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class GrizzlyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public GrizzlyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

