/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.hk2.scopes.PerLookup;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyRequestPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.HeadersFactory;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.JerseyContainerRequestContext;
import org.glassfish.jersey.server.JerseyContainerResponseContext;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.jvnet.hk2.annotations.Inject;

public final class GrizzlyHttpContainer
extends HttpHandler
implements Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(GrizzlyHttpContainer.class.getName()), Level.FINEST);
    private static final CompletionHandler<Response> EMPTY_COMPLETION_HANDLER = new CompletionHandler<Response>(){

        public void cancelled() {
        }

        public void failed(Throwable throwable) {
        }

        public void completed(Response result) {
        }

        public void updated(Response result) {
        }
    };
    private volatile ApplicationHandler appHandler;
    private final ContainerLifecycleListener containerListener;

    GrizzlyHttpContainer(ApplicationHandler application) {
        this.appHandler = application;
        this.containerListener = ConfigHelper.getContainerLifecycleListener((ApplicationHandler)application);
        this.appHandler.registerAdditionalModules((Set)new HashSet<Module>(){
            {
                this.add(new GrizzlyModule());
            }
        });
    }

    public void start() {
        super.start();
        this.containerListener.onStartup((Container)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(final Request request, final Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response);
        try {
            logger.debugLog("GrizzlyHttpContaner.service(...) started", new Object[0]);
            URI baseUri = this.getBaseUri(request);
            JerseyContainerRequestContext requestContext = new JerseyContainerRequestContext(baseUri, this.getRequestUri(baseUri, request), request.getMethod().getMethodString(), this.getSecurityContext(request), (PropertiesDelegate)new GrizzlyRequestPropertiesDelegate(request));
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getHeaderNames()) {
                requestContext.headers(headerName, request.getHeaders(headerName));
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(new RequestScopedInitializer(){

                public void initialize(Services services) {
                    ((Ref)services.forContract((TypeLiteral)new TypeLiteral<Ref<Request>>(){}).get()).set((Object)request);
                    ((Ref)services.forContract((TypeLiteral)new TypeLiteral<Ref<Response>>(){}).get()).set((Object)response);
                }
            });
            this.appHandler.handle(requestContext);
        }
        finally {
            logger.debugLog("GrizzlyHttpContaner.service(...) finished", new Object[0]);
        }
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.appHandler.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler = new ApplicationHandler((Application)configuration.addModules(new Module[]{new GrizzlyModule()}));
        this.containerListener.onReload((Container)this);
    }

    public void destroy() {
        super.destroy();
        this.containerListener.onShutdown((Container)this);
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private URI getRequestUri(URI baseUri, Request grizzlyRequest) {
        String originalUri = UriBuilder.fromPath((String)grizzlyRequest.getRequest().getRequestURIRef().getOriginalRequestURIBC().toString(Charsets.DEFAULT_CHARSET)).build(new Object[0]).toString();
        String queryString = grizzlyRequest.getQueryString();
        if (queryString != null) {
            originalUri = originalUri + "?" + queryString;
        }
        URI requestUri = baseUri.resolve(originalUri);
        return requestUri;
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final String name;
        private final Response grizzlyResponse;

        ResponseWriter(Response response) {
            this.grizzlyResponse = response;
            if (logger.isDebugLoggable()) {
                this.name = "ResponseWriter {id=" + UUID.randomUUID().toString() + ", grizzlyResponse=" + this.grizzlyResponse.hashCode() + '}';
                logger.debugLog("{0} - init", new Object[]{this.name});
            } else {
                this.name = "ResponseWriter";
            }
        }

        public String toString() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            try {
                if (this.grizzlyResponse.isSuspended()) {
                    this.grizzlyResponse.resume();
                }
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - commit() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - commit() called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                this.grizzlyResponse.cancel();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - cancel() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - cancel() called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                this.grizzlyResponse.suspend(timeOut, timeUnit, EMPTY_COMPLETION_HANDLER, new TimeoutHandler(){

                    public boolean onTimeout(Response response) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout((ContainerResponseWriter)ResponseWriter.this);
                        }
                        return false;
                    }
                });
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                this.grizzlyResponse.getSuspendContext().setTimeout(timeOut, timeUnit);
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - setSuspendTimeout(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - setSuspendTimeout(...) called", new Object[]{this.name});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream writeResponseStatusAndHeaders(long contentLength, JerseyContainerResponseContext context) throws ContainerException {
            OutputStream outputStream;
            try {
                this.grizzlyResponse.setStatus(context.getStatus());
                this.grizzlyResponse.setContentLengthLong(contentLength);
                for (Map.Entry e : HeadersFactory.getStringHeaders((MultivaluedMap)context.getHeaders()).entrySet()) {
                    for (String value : (List)e.getValue()) {
                        this.grizzlyResponse.addHeader((String)e.getKey(), value);
                    }
                }
                outputStream = this.grizzlyResponse.getOutputStream();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
            return outputStream;
        }
    }

    private static class GrizzlyModule
    extends AbstractModule {
        private GrizzlyModule() {
        }

        protected void configure() {
            this.bind(Request.class, new Class[0]).toFactory(GrizzlyRequestReferencingFactory.class).in(PerLookup.class);
            this.bind((TypeLiteral)new TypeLiteral<Ref<Request>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
            this.bind(Response.class, new Class[0]).toFactory(GrizzlyResponseReferencingFactory.class).in(PerLookup.class);
            this.bind((TypeLiteral)new TypeLiteral<Ref<Response>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        }
    }

    private static class GrizzlyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        public GrizzlyResponseReferencingFactory(@Inject Factory<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class GrizzlyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        public GrizzlyRequestReferencingFactory(@Inject Factory<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

