/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdkhttp;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executors;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.jdkhttp.JdkHttpHandlerContainer;
import org.glassfish.jersey.jdkhttp.internal.LocalizationMessages;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ConfigHelper;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public class JdkHttpServerFactory {
    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) throws ProcessingException {
        JdkHttpHandlerContainer handler = (JdkHttpHandlerContainer)ContainerFactory.createContainer(JdkHttpHandlerContainer.class, (Application)configuration);
        return JdkHttpServerFactory.createHttpServer(uri, handler, ConfigHelper.getContainerLifecycleListener((ApplicationHandler)new ApplicationHandler((Application)configuration)));
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler) throws ProcessingException {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer(appHandler), ConfigHelper.getContainerLifecycleListener((ApplicationHandler)appHandler));
    }

    private static HttpServer createHttpServer(URI uri, JdkHttpHandlerContainer handler, ContainerLifecycleListener containerListener) throws ProcessingException {
        HttpServer server;
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_NULL());
        }
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_SCHEME_UNKNOWN(uri));
        }
        String path = uri.getPath();
        if (path == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_NULL(uri));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_EMPTY(uri));
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_START(uri));
        }
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        try {
            server = scheme.equalsIgnoreCase("http") ? HttpServer.create(new InetSocketAddress(port), 0) : HttpsServer.create(new InetSocketAddress(port), 0);
        }
        catch (IOException ioe) {
            throw new ProcessingException(LocalizationMessages.ERROR_CONTAINER_EXCEPTION_IO(), (Throwable)ioe);
        }
        server.setExecutor(Executors.newCachedThreadPool());
        server.createContext(path, handler);
        server.start();
        containerListener.onStartup((Container)handler);
        return server;
    }

    private JdkHttpServerFactory() {
    }
}

