/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdkhttp;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.jdkhttp.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.spi.ContainerRequestContext;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.server.spi.JerseyContainerRequestContext;

public class JdkHttpHandlerContainer
implements HttpHandler {
    private final ApplicationHandler appHandler;

    JdkHttpHandlerContainer(ApplicationHandler appHandler) {
        this.appHandler = appHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        boolean isSecure;
        URI exchangeUri = exchange.getRequestURI();
        String decodedBasePath = exchange.getHttpContext().getPath();
        if (!decodedBasePath.endsWith("/")) {
            if (decodedBasePath.equals(exchangeUri.getPath())) {
                exchangeUri = UriBuilder.fromUri((URI)exchangeUri).path("/").build(new Object[0]);
            }
            decodedBasePath = decodedBasePath + "/";
        }
        String scheme = (isSecure = exchange instanceof HttpsExchange) ? "https" : "http";
        URI baseUri = null;
        try {
            Object hostHeader = exchange.getRequestHeaders().get("Host");
            if (hostHeader != null) {
                StringBuilder sb = new StringBuilder(scheme);
                sb.append("://").append((String)hostHeader.get(0)).append(decodedBasePath);
                baseUri = new URI(sb.toString());
            } else {
                InetSocketAddress addr = exchange.getLocalAddress();
                baseUri = new URI(scheme, null, addr.getHostName(), addr.getPort(), decodedBasePath, null, null);
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        URI requestUri = baseUri.resolve(exchangeUri);
        Request.RequestBuilder requestBuilder = Requests.from((URI)baseUri, (URI)requestUri, (String)exchange.getRequestMethod(), (InputStream)exchange.getRequestBody());
        for (Map.Entry<String, List<String>> entry : exchange.getRequestHeaders().entrySet()) {
            for (String value : entry.getValue()) {
                requestBuilder.header(entry.getKey(), (Object)value);
            }
        }
        Request jaxRsRequest = requestBuilder.build();
        ResponseWriter responseWriter = new ResponseWriter(exchange);
        JerseyContainerRequestContext containerRequestCtx = new JerseyContainerRequestContext(jaxRsRequest, (ContainerResponseWriter)responseWriter, this.getSecurityContext(exchange.getPrincipal(), isSecure), null);
        try {
            this.appHandler.apply((ContainerRequestContext)containerRequestCtx);
        }
        finally {
            responseWriter.closeAndLogWarning();
        }
    }

    private SecurityContext getSecurityContext(final Principal principal, final boolean isSecure) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return isSecure;
            }

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        HttpExchange exchange;
        private final AtomicBoolean closed;

        ResponseWriter(HttpExchange exchange) {
            this.exchange = exchange;
            this.closed = new AtomicBoolean(false);
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, Response jaxRsResponse) throws ContainerException {
            MultivaluedMap jaxRsHeaders = jaxRsResponse.getHeaders().asMap();
            Headers serverHeaders = this.exchange.getResponseHeaders();
            for (Map.Entry e : jaxRsHeaders.entrySet()) {
                for (String value : (List)e.getValue()) {
                    serverHeaders.add((String)e.getKey(), value);
                }
            }
            try {
                if (jaxRsResponse.getStatus() == 204) {
                    this.exchange.sendResponseHeaders(jaxRsResponse.getStatus(), -1L);
                } else {
                    this.exchange.sendResponseHeaders(jaxRsResponse.getStatus(), this.getResponseLength(contentLength));
                }
            }
            catch (IOException ioe) {
                throw new ContainerException("Error during writing out the response headers.", (Throwable)ioe);
            }
            return this.exchange.getResponseBody();
        }

        private long getResponseLength(long contentLength) {
            if (contentLength == 0L) {
                return -1L;
            }
            if (contentLength < 0L) {
                return 0L;
            }
            return contentLength;
        }

        public void suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            throw new UnsupportedOperationException("Method suspend is not support by the container.");
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            throw new UnsupportedOperationException("Method suspend is not support by the container.");
        }

        public void cancel() {
            this.commit();
        }

        public void commit() {
            if (this.closed.compareAndSet(false, true)) {
                this.exchange.close();
            }
        }

        private void closeAndLogWarning() {
            if (this.closed.compareAndSet(false, true)) {
                Logger.getLogger(JdkHttpHandlerContainer.class.getName()).log(Level.WARNING, LocalizationMessages.ERROR_RESPONSEWRITER_RESPONSE_UNCOMMITED());
                this.exchange.close();
            }
        }
    }
}

