/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.jdkhttp.JdkHttpHandlerContainer;
import org.glassfish.jersey.jdkhttp.internal.LocalizationMessages;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;

public final class JdkHttpServerFactory {
    private static final Logger LOG = Logger.getLogger(JdkHttpServerFactory.class.getName());

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) {
        return JdkHttpServerFactory.createHttpServer(uri, configuration, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration), start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, ServiceLocator parentLocator) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration, parentLocator), true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, SSLContext sslContext, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration), sslContext != null ? new HttpsConfigurator(sslContext) : null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, HttpsConfigurator httpsConfigurator, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration), httpsConfigurator, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, ServiceLocator parentLocator, HttpsConfigurator httpsConfigurator) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration, parentLocator), httpsConfigurator, true);
    }

    private static HttpServer createHttpServer(URI uri, JdkHttpHandlerContainer handler, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, handler, null, start);
    }

    private static HttpServer createHttpServer(URI uri, JdkHttpHandlerContainer handler, HttpsConfigurator httpsConfigurator, boolean start) {
        HttpServer wrapper;
        HttpServer server;
        String path;
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_NULL());
        }
        String scheme = uri.getScheme();
        boolean isHttp = "http".equalsIgnoreCase(scheme);
        boolean isHttps = "https".equalsIgnoreCase(scheme);
        if (isHttp) {
            if (httpsConfigurator != null) {
                throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_SCHEME_SECURED());
            }
        } else if (isHttps) {
            if (httpsConfigurator == null) {
                if (start) {
                    throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_HTTPS_NO_SSL());
                }
                LOG.info(LocalizationMessages.INFO_CONTAINER_HTTPS_NO_SSL());
            }
        } else {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_SCHEME_UNKNOWN(uri));
        }
        if ((path = uri.getPath()) == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_NULL(uri));
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_EMPTY(uri));
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_START(uri));
        }
        int port = uri.getPort() == -1 ? (isHttp ? 80 : 443) : uri.getPort();
        try {
            server = isHttp ? HttpServer.create(new InetSocketAddress(port), 0) : HttpsServer.create(new InetSocketAddress(port), 0);
        }
        catch (IOException ioe) {
            throw new ProcessingException(LocalizationMessages.ERROR_CONTAINER_EXCEPTION_IO(), (Throwable)ioe);
        }
        if (isHttps && httpsConfigurator != null) {
            ((HttpsServer)server).setHttpsConfigurator(httpsConfigurator);
        }
        server.setExecutor(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("jdk-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build()));
        server.createContext(path, handler);
        HttpServer httpServer = wrapper = isHttp ? JdkHttpServerFactory.createHttpServerWrapper(server, handler) : JdkHttpServerFactory.createHttpsServerWrapper((HttpsServer)server, handler);
        if (start) {
            wrapper.start();
        }
        return wrapper;
    }

    private static HttpServer createHttpsServerWrapper(final HttpsServer delegate, final JdkHttpHandlerContainer handler) {
        return new HttpsServer(){

            @Override
            public void setHttpsConfigurator(HttpsConfigurator httpsConfigurator) {
                delegate.setHttpsConfigurator(httpsConfigurator);
            }

            @Override
            public HttpsConfigurator getHttpsConfigurator() {
                return delegate.getHttpsConfigurator();
            }

            @Override
            public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
                delegate.bind(inetSocketAddress, i);
            }

            @Override
            public void start() {
                delegate.start();
                handler.onServerStart();
            }

            @Override
            public void setExecutor(Executor executor) {
                delegate.setExecutor(executor);
            }

            @Override
            public Executor getExecutor() {
                return delegate.getExecutor();
            }

            @Override
            public void stop(int i) {
                handler.onServerStop();
                delegate.stop(i);
            }

            @Override
            public HttpContext createContext(String s, HttpHandler httpHandler) {
                return delegate.createContext(s, httpHandler);
            }

            @Override
            public HttpContext createContext(String s) {
                return delegate.createContext(s);
            }

            @Override
            public void removeContext(String s) throws IllegalArgumentException {
                delegate.removeContext(s);
            }

            @Override
            public void removeContext(HttpContext httpContext) {
                delegate.removeContext(httpContext);
            }

            @Override
            public InetSocketAddress getAddress() {
                return delegate.getAddress();
            }
        };
    }

    private static HttpServer createHttpServerWrapper(final HttpServer delegate, final JdkHttpHandlerContainer handler) {
        return new HttpServer(){

            @Override
            public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
                delegate.bind(inetSocketAddress, i);
            }

            @Override
            public void start() {
                delegate.start();
                handler.onServerStart();
            }

            @Override
            public void setExecutor(Executor executor) {
                delegate.setExecutor(executor);
            }

            @Override
            public Executor getExecutor() {
                return delegate.getExecutor();
            }

            @Override
            public void stop(int i) {
                handler.onServerStop();
                delegate.stop(i);
            }

            @Override
            public HttpContext createContext(String s, HttpHandler httpHandler) {
                return delegate.createContext(s, httpHandler);
            }

            @Override
            public HttpContext createContext(String s) {
                return delegate.createContext(s);
            }

            @Override
            public void removeContext(String s) throws IllegalArgumentException {
                delegate.removeContext(s);
            }

            @Override
            public void removeContext(HttpContext httpContext) {
                delegate.removeContext(httpContext);
            }

            @Override
            public InetSocketAddress getAddress() {
                return delegate.getAddress();
            }
        };
    }

    private JdkHttpServerFactory() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }
}

