/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.jdkhttp.JdkHttpHandlerContainer;
import org.glassfish.jersey.jdkhttp.internal.LocalizationMessages;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;

public final class JdkHttpServerFactory {
    private static final Logger LOG = Logger.getLogger(JdkHttpServerFactory.class.getName());

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) {
        return JdkHttpServerFactory.createHttpServer(uri, configuration, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration), start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, Object parentContext) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration, parentContext), true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, SSLContext sslContext) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration), sslContext, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, SSLContext sslContext, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration), sslContext, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, Object parentContext, SSLContext sslContext, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, new JdkHttpHandlerContainer((Application)configuration, parentContext), sslContext, start);
    }

    private static HttpServer createHttpServer(URI uri, JdkHttpHandlerContainer handler, boolean start) {
        return JdkHttpServerFactory.createHttpServer(uri, handler, null, start);
    }

    private static HttpServer createHttpServer(URI uri, JdkHttpHandlerContainer handler, SSLContext sslContext, boolean start) {
        HttpServer wrapper;
        HttpServer server;
        String _path;
        HttpsConfigurator httpsConfigurator;
        if (uri == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_NULL());
        }
        String scheme = uri.getScheme();
        boolean isHttp = "http".equalsIgnoreCase(scheme);
        boolean isHttps = "https".equalsIgnoreCase(scheme);
        HttpsConfigurator httpsConfigurator2 = httpsConfigurator = sslContext != null ? new HttpsConfigurator(sslContext) : null;
        if (isHttp) {
            if (httpsConfigurator != null) {
                LOG.warning(LocalizationMessages.WARNING_CONTAINER_URI_SCHEME_SECURED());
            }
        } else if (isHttps) {
            if (httpsConfigurator == null) {
                if (start) {
                    throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_HTTPS_NO_SSL());
                }
                LOG.info(LocalizationMessages.INFO_CONTAINER_HTTPS_NO_SSL());
            }
        } else {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_SCHEME_UNKNOWN(uri));
        }
        if ((_path = uri.getPath()) == null) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_NULL(uri));
        }
        if (_path.isEmpty()) {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_EMPTY(uri));
        }
        if (_path.charAt(0) != '/') {
            throw new IllegalArgumentException(LocalizationMessages.ERROR_CONTAINER_URI_PATH_START(uri));
        }
        String appPath = handler.getApplicationHandler().getConfiguration().getApplicationPath();
        String uriPath = appPath == null ? _path : _path + "/" + appPath;
        String path = uriPath.replaceAll("/{2,}", "/");
        int port = uri.getPort() == -1 ? (isHttp ? 80 : 443) : uri.getPort();
        InetSocketAddress socketAddress = uri.getHost() == null ? new InetSocketAddress(port) : new InetSocketAddress(uri.getHost(), port);
        try {
            server = isHttp ? HttpServer.create(socketAddress, 0) : HttpsServer.create(socketAddress, 0);
        }
        catch (IOException ioe) {
            throw new ProcessingException(LocalizationMessages.ERROR_CONTAINER_EXCEPTION_IO(), (Throwable)ioe);
        }
        if (isHttps && httpsConfigurator != null) {
            ((HttpsServer)server).setHttpsConfigurator(httpsConfigurator);
        }
        server.setExecutor(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("jdk-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build()));
        server.createContext(path, handler);
        HttpServer httpServer = wrapper = isHttp ? JdkHttpServerFactory.createHttpServerWrapper(server, handler) : JdkHttpServerFactory.createHttpsServerWrapper((HttpsServer)server, handler);
        if (start) {
            wrapper.start();
        }
        return wrapper;
    }

    private static HttpServer createHttpsServerWrapper(final HttpsServer delegate, final JdkHttpHandlerContainer handler) {
        return new HttpsServer(){

            @Override
            public void setHttpsConfigurator(HttpsConfigurator httpsConfigurator) {
                delegate.setHttpsConfigurator(httpsConfigurator);
            }

            @Override
            public HttpsConfigurator getHttpsConfigurator() {
                return delegate.getHttpsConfigurator();
            }

            @Override
            public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
                delegate.bind(inetSocketAddress, i);
            }

            @Override
            public void start() {
                delegate.start();
                handler.onServerStart();
            }

            @Override
            public void setExecutor(Executor executor) {
                delegate.setExecutor(executor);
            }

            @Override
            public Executor getExecutor() {
                return delegate.getExecutor();
            }

            @Override
            public void stop(int i) {
                handler.onServerStop();
                delegate.stop(i);
            }

            @Override
            public HttpContext createContext(String s, HttpHandler httpHandler) {
                return delegate.createContext(s, httpHandler);
            }

            @Override
            public HttpContext createContext(String s) {
                return delegate.createContext(s);
            }

            @Override
            public void removeContext(String s) throws IllegalArgumentException {
                delegate.removeContext(s);
            }

            @Override
            public void removeContext(HttpContext httpContext) {
                delegate.removeContext(httpContext);
            }

            @Override
            public InetSocketAddress getAddress() {
                return delegate.getAddress();
            }
        };
    }

    private static HttpServer createHttpServerWrapper(final HttpServer delegate, final JdkHttpHandlerContainer handler) {
        return new HttpServer(){

            @Override
            public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
                delegate.bind(inetSocketAddress, i);
            }

            @Override
            public void start() {
                delegate.start();
                handler.onServerStart();
            }

            @Override
            public void setExecutor(Executor executor) {
                delegate.setExecutor(executor);
            }

            @Override
            public Executor getExecutor() {
                return delegate.getExecutor();
            }

            @Override
            public void stop(int i) {
                handler.onServerStop();
                delegate.stop(i);
            }

            @Override
            public HttpContext createContext(String s, HttpHandler httpHandler) {
                return delegate.createContext(s, httpHandler);
            }

            @Override
            public HttpContext createContext(String s) {
                return delegate.createContext(s);
            }

            @Override
            public void removeContext(String s) throws IllegalArgumentException {
                delegate.removeContext(s);
            }

            @Override
            public void removeContext(HttpContext httpContext) {
                delegate.removeContext(httpContext);
            }

            @Override
            public InetSocketAddress getAddress() {
                return delegate.getAddress();
            }
        };
    }

    private JdkHttpServerFactory() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }
}

