/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdkhttp;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsExchange;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.jdkhttp.internal.LocalizationMessages;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class JdkHttpHandlerContainer
implements HttpHandler,
Container {
    private static final Logger LOGGER = Logger.getLogger(JdkHttpHandlerContainer.class.getName());
    private volatile ApplicationHandler appHandler;

    JdkHttpHandlerContainer(Application application) {
        this.appHandler = new ApplicationHandler(application);
    }

    JdkHttpHandlerContainer(Class<? extends Application> applicationClass) {
        this.appHandler = new ApplicationHandler(applicationClass);
    }

    JdkHttpHandlerContainer(Application application, Object parentContext) {
        this.appHandler = new ApplicationHandler(application, null, parentContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        boolean isSecure;
        URI exchangeUri = exchange.getRequestURI();
        String decodedBasePath = exchange.getHttpContext().getPath();
        if (!decodedBasePath.endsWith("/")) {
            if (decodedBasePath.equals(exchangeUri.getPath())) {
                exchangeUri = UriBuilder.fromUri((URI)exchangeUri).path("/").build(new Object[0]);
            }
            decodedBasePath = decodedBasePath + "/";
        }
        String scheme = (isSecure = exchange instanceof HttpsExchange) ? "https" : "http";
        URI baseUri = this.getBaseUri(exchange, decodedBasePath, scheme);
        URI requestUri = this.getRequestUri(exchange, baseUri);
        ResponseWriter responseWriter = new ResponseWriter(exchange);
        ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, exchange.getRequestMethod(), this.getSecurityContext(exchange.getPrincipal(), isSecure), (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)this.appHandler.getConfiguration());
        requestContext.setEntityStream(exchange.getRequestBody());
        requestContext.getHeaders().putAll((Map)exchange.getRequestHeaders());
        requestContext.setWriter((ContainerResponseWriter)responseWriter);
        try {
            this.appHandler.handle(requestContext);
        }
        finally {
            responseWriter.closeAndLogWarning();
        }
    }

    private URI getBaseUri(HttpExchange exchange, String decodedBasePath, String scheme) {
        URI baseUri;
        try {
            Object hostHeader = exchange.getRequestHeaders().get("Host");
            if (hostHeader != null) {
                baseUri = new URI(scheme + "://" + (String)hostHeader.get(0) + decodedBasePath);
            } else {
                InetSocketAddress addr = exchange.getLocalAddress();
                baseUri = new URI(scheme, null, addr.getHostName(), addr.getPort(), decodedBasePath, null, null);
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return baseUri;
    }

    private URI getRequestUri(HttpExchange exchange, URI baseUri) {
        try {
            return new URI(this.getServerAddress(baseUri) + exchange.getRequestURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getServerAddress(URI baseUri) throws URISyntaxException {
        return new URI(baseUri.getScheme(), null, baseUri.getHost(), baseUri.getPort(), null, null, null).toString();
    }

    private SecurityContext getSecurityContext(final Principal principal, final boolean isSecure) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return isSecure;
            }

            public Principal getUserPrincipal() {
                return principal;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration);
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    void onServerStart() {
        this.appHandler.onStartup((Container)this);
    }

    void onServerStop() {
        this.appHandler.onShutdown((Container)this);
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final HttpExchange exchange;
        private final AtomicBoolean closed;

        ResponseWriter(HttpExchange exchange) {
            this.exchange = exchange;
            this.closed = new AtomicBoolean(false);
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            MultivaluedMap responseHeaders = context.getStringHeaders();
            Headers serverHeaders = this.exchange.getResponseHeaders();
            for (Map.Entry e : responseHeaders.entrySet()) {
                for (String value : (List)e.getValue()) {
                    serverHeaders.add((String)e.getKey(), value);
                }
            }
            try {
                if (context.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                    this.exchange.sendResponseHeaders(context.getStatus(), -1L);
                } else {
                    this.exchange.sendResponseHeaders(context.getStatus(), this.getResponseLength(contentLength));
                }
            }
            catch (IOException ioe) {
                throw new ContainerException(LocalizationMessages.ERROR_RESPONSEWRITER_WRITING_HEADERS(), (Throwable)ioe);
            }
            return this.exchange.getResponseBody();
        }

        private long getResponseLength(long contentLength) {
            if (contentLength == 0L) {
                return -1L;
            }
            if (contentLength < 0L) {
                return 0L;
            }
            return contentLength;
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            throw new UnsupportedOperationException("Method suspend is not supported by the container.");
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            throw new UnsupportedOperationException("Method setSuspendTimeout is not supported by the container.");
        }

        public void failure(Throwable error) {
            try {
                this.exchange.sendResponseHeaders(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), this.getResponseLength(0L));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LocalizationMessages.ERROR_RESPONSEWRITER_SENDING_FAILURE_RESPONSE(), e);
            }
            finally {
                this.commit();
                this.rethrow(error);
            }
        }

        public boolean enableResponseBuffering() {
            return true;
        }

        public void commit() {
            if (this.closed.compareAndSet(false, true)) {
                this.exchange.close();
            }
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }

        private void closeAndLogWarning() {
            if (this.closed.compareAndSet(false, true)) {
                this.exchange.close();
                LOGGER.log(Level.WARNING, LocalizationMessages.ERROR_RESPONSEWRITER_RESPONSE_UNCOMMITED());
            }
        }
    }
}

