/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public final class JettyHttpContainer
extends AbstractHandler
implements Container {
    private static final ExtendedLogger LOGGER = new ExtendedLogger(Logger.getLogger(JettyHttpContainer.class.getName()), Level.FINEST);
    private static final Type REQUEST_TYPE = new GenericType<Ref<Request>>(){}.getType();
    private static final Type RESPONSE_TYPE = new GenericType<Ref<Response>>(){}.getType();
    private static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private boolean configSetStatusOverSendError;
    private volatile ApplicationHandler appHandler;

    public void handle(String target, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (request.isHandled()) {
            return;
        }
        Response response = request.getResponse();
        ResponseWriter responseWriter = new ResponseWriter(request, response, this.configSetStatusOverSendError);
        URI baseUri = this.getBaseUri(request);
        URI requestUri = this.getRequestUri(request, baseUri);
        try {
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)this.appHandler.getConfiguration());
            requestContext.setEntityStream((InputStream)request.getInputStream());
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                requestContext.headers(headerName, new Object[]{headerValue == null ? "" : headerValue});
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(injectionManager -> {
                ((Ref)injectionManager.getInstance(REQUEST_TYPE)).set((Object)request);
                ((Ref)injectionManager.getInstance(RESPONSE_TYPE)).set((Object)response);
            });
            request.setHandled(true);
            this.appHandler.handle(requestContext);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private URI getRequestUri(Request request, URI baseUri) {
        try {
            String serverAddress = this.getServerAddress(baseUri);
            String uri = request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                uri = uri + "?" + ContainerUtils.encodeUnsafeCharacters((String)queryString);
            }
            return new URI(serverAddress + uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getServerAddress(URI baseUri) {
        String serverAddress = baseUri.toString();
        if (serverAddress.charAt(serverAddress.length() - 1) == '/') {
            return serverAddress.substring(0, serverAddress.length() - 1);
        }
        return serverAddress;
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration.register((Object)new JettyBinder()));
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
        this.cacheConfigSetStatusOverSendError();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.appHandler.onStartup((Container)this);
    }

    public void doStop() throws Exception {
        super.doStop();
        this.appHandler.onShutdown((Container)this);
        this.appHandler = null;
    }

    JettyHttpContainer(Application application, Object parentContext) {
        this.appHandler = new ApplicationHandler(application, (Binder)new JettyBinder(), parentContext);
    }

    JettyHttpContainer(Application application) {
        this.appHandler = new ApplicationHandler(application, (Binder)new JettyBinder());
        this.cacheConfigSetStatusOverSendError();
    }

    private void cacheConfigSetStatusOverSendError() {
        this.configSetStatusOverSendError = (Boolean)ServerProperties.getValue((Map)this.getConfiguration().getProperties(), (String)"jersey.config.server.response.setStatusOverSendError", (Object)false, Boolean.class);
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final Response response;
        private final Continuation continuation;
        private final boolean configSetStatusOverSendError;

        ResponseWriter(Request request, Response response, boolean configSetStatusOverSendError) {
            this.response = response;
            this.continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            this.configSetStatusOverSendError = configSetStatusOverSendError;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            Response.StatusType statusInfo = context.getStatusInfo();
            int code = statusInfo.getStatusCode();
            String reason = statusInfo.getReasonPhrase() == null ? HttpStatus.getMessage((int)code) : statusInfo.getReasonPhrase();
            this.response.setStatusWithReason(code, reason);
            if (contentLength != -1L && contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)contentLength);
            }
            for (Map.Entry e : context.getStringHeaders().entrySet()) {
                for (String value : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), value);
                }
            }
            try {
                return this.response.getOutputStream();
            }
            catch (IOException ioe) {
                throw new ContainerException("Error during writing out the response headers.", (Throwable)ioe);
            }
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                if (timeOut > 0L) {
                    long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
                    this.continuation.setTimeout(timeoutMillis);
                }
                this.continuation.addContinuationListener(new ContinuationListener(){

                    public void onComplete(Continuation continuation) {
                    }

                    public void onTimeout(Continuation continuation) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout((ContainerResponseWriter)this);
                        }
                    }
                });
                this.continuation.suspend((ServletResponse)this.response);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            if (timeOut > 0L) {
                long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeOut, timeUnit);
                this.continuation.setTimeout(timeoutMillis);
            }
        }

        public void commit() {
            try {
                this.response.closeOutput();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LocalizationMessages.UNABLE_TO_CLOSE_RESPONSE(), (Throwable)e);
            }
            finally {
                if (this.continuation.isSuspended()) {
                    this.continuation.complete();
                }
                LOGGER.log(Level.FINEST, "commit() called");
            }
        }

        public void failure(Throwable error) {
            block8: {
                try {
                    if (this.response.isCommitted()) break block8;
                    try {
                        if (this.configSetStatusOverSendError) {
                            this.response.reset();
                            this.response.setStatus(INTERNAL_SERVER_ERROR, "Request failed.");
                        } else {
                            this.response.sendError(INTERNAL_SERVER_ERROR, "Request failed.");
                        }
                    }
                    catch (IllegalStateException ex) {
                        LOGGER.log(Level.FINER, "Unable to reset failed response.", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(INTERNAL_SERVER_ERROR, "Request failed."), (Throwable)ex);
                    }
                }
                finally {
                    LOGGER.log(Level.FINEST, "failure(...) called");
                    this.commit();
                    this.rethrow(error);
                }
            }
        }

        public boolean enableResponseBuffering() {
            return false;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class JettyBinder
    extends AbstractBinder {
        private JettyBinder() {
        }

        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(JettyRequestReferencingFactory.class).to(Request.class)).proxy(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Request>>(){})).in(RequestScoped.class);
            ((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(JettyResponseReferencingFactory.class).to(Response.class)).proxy(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Response>>(){})).in(RequestScoped.class);
        }
    }

    private static class JettyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public JettyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class JettyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public JettyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

