/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty.http2;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Application;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.jetty.JettyHttpContainer;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.jetty.JettyHttpContainerProvider;
import org.glassfish.jersey.jetty.http2.LocalizationMessages;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JettyHttp2ContainerFactory {
    private JettyHttp2ContainerFactory() {
    }

    public static Server createHttp2Server(URI uri) throws ProcessingException {
        return JettyHttp2ContainerFactory.createHttp2Server(uri, null, null, true);
    }

    public static Server createHttp2Server(URI uri, ResourceConfig configuration, boolean start) throws ProcessingException {
        return JettyHttp2ContainerFactory.createHttp2Server(uri, null, (JettyHttpContainer)ContainerFactory.createContainer(JettyHttpContainer.class, (Application)configuration), start);
    }

    public static Server createHttp2Server(URI uri, boolean start) throws ProcessingException {
        return JettyHttp2ContainerFactory.createHttp2Server(uri, null, null, start);
    }

    public static Server createHttp2Server(URI uri, ResourceConfig config, boolean start, Object parentContext) {
        return JettyHttp2ContainerFactory.createHttp2Server(uri, null, (JettyHttpContainer)new JettyHttpContainerProvider().createContainer(JettyHttpContainer.class, (Application)config, parentContext), start);
    }

    public static Server createHttp2Server(URI uri, SslContextFactory.Server sslContextFactory, JettyHttpContainer handler, boolean start) {
        Server server = JettyHttpContainerFactory.createServer((URI)uri, (SslContextFactory.Server)sslContextFactory, (JettyHttpContainer)handler, (boolean)false);
        ServerConnector httpServerConnector = (ServerConnector)server.getConnectors()[0];
        HttpConnectionFactory httpConnectionFactory = (HttpConnectionFactory)httpServerConnector.getConnectionFactory(HttpConnectionFactory.class);
        HttpConfiguration config = httpConnectionFactory.getHttpConfiguration();
        List<ConnectionFactory> factories = JettyHttp2ContainerFactory.getConnectionFactories(config, sslContextFactory);
        for (ConnectionFactory factory : factories) {
            httpServerConnector.addConnectionFactory(factory);
        }
        server.setConnectors(new Connector[]{httpServerConnector});
        if (start) {
            try {
                server.start();
            }
            catch (Exception e) {
                throw new ProcessingException(LocalizationMessages.ERROR_WHEN_CREATING_SERVER(), (Throwable)e);
            }
        }
        return server;
    }

    private static List<ConnectionFactory> getConnectionFactories(HttpConfiguration config, SslContextFactory.Server sslContextFactory) {
        ArrayList<ConnectionFactory> factories = new ArrayList<ConnectionFactory>();
        if (sslContextFactory != null) {
            factories.add((ConnectionFactory)new HTTP2ServerConnectionFactory(config));
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol("h2");
            factories.add((ConnectionFactory)new SslConnectionFactory(sslContextFactory, alpn.getProtocol()));
            factories.add((ConnectionFactory)alpn);
        } else {
            factories.add((ConnectionFactory)new HTTP2CServerConnectionFactory(config));
        }
        return factories;
    }
}

