/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty.servlet;

import jakarta.servlet.Servlet;
import jakarta.ws.rs.ProcessingException;
import java.net.URI;
import java.util.Map;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.ServletContainer;

public final class JettyWebContainerFactory {
    private JettyWebContainerFactory() {
    }

    public static Server create(String u) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u));
    }

    public static Server create(String u, Map<String, String> initParams) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u), initParams);
    }

    public static Server create(URI u) throws Exception {
        return JettyWebContainerFactory.create(u, ServletContainer.class);
    }

    public static Server create(URI u, Map<String, String> initParams) throws Exception {
        return JettyWebContainerFactory.create(u, ServletContainer.class, initParams);
    }

    public static Server create(String u, Class<? extends Servlet> c) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u), c);
    }

    public static Server create(String u, Class<? extends Servlet> c, Map<String, String> initParams) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u), c, initParams);
    }

    public static Server create(URI u, Class<? extends Servlet> c) throws Exception {
        return JettyWebContainerFactory.create(u, c, null);
    }

    public static Server create(URI u, Class<? extends Servlet> c, Map<String, String> initParams) throws Exception {
        return JettyWebContainerFactory.create(u, c, null, initParams, null);
    }

    private static Server create(URI u, Class<? extends Servlet> c, Servlet servlet, Map<String, String> initParams, Map<String, String> contextInitParams) throws Exception {
        throw new ProcessingException(LocalizationMessages.NOT_SUPPORTED());
    }

    public static Server create(URI u, Servlet servlet, Map<String, String> initParams, Map<String, String> contextInitParams) throws Exception {
        if (servlet == null) {
            throw new IllegalArgumentException("The servlet must not be null");
        }
        return JettyWebContainerFactory.create(u, null, servlet, initParams, contextInitParams);
    }
}

