/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.netty.connector.internal.NettyInputStream;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.netty.httpserver.NettyResponseWriter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class JerseyServerHandler
extends ChannelInboundHandlerAdapter {
    private final URI baseUri;
    private final LinkedBlockingDeque<InputStream> isList = new LinkedBlockingDeque();
    private final NettyHttpContainer container;

    public JerseyServerHandler(URI baseUri, NettyHttpContainer container) {
        this.baseUri = baseUri;
        this.container = container;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (HttpUtil.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            this.isList.clear();
            final ContainerRequest requestContext = this.createContainerRequest(ctx, req);
            requestContext.setWriter((ContainerResponseWriter)new NettyResponseWriter(ctx, req, this.container));
            this.container.getExecutorService().execute(new Runnable(){

                @Override
                public void run() {
                    JerseyServerHandler.this.container.getApplicationHandler().handle(requestContext);
                }
            });
        }
        if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            if (content.isReadable()) {
                this.isList.add((InputStream)new ByteBufInputStream(content));
            }
            if (msg instanceof LastHttpContent) {
                this.isList.add(NettyInputStream.END_OF_INPUT);
            }
        }
    }

    private ContainerRequest createContainerRequest(ChannelHandlerContext ctx, HttpRequest req) {
        String s = req.uri().startsWith("/") ? req.uri().substring(1) : req.uri();
        URI requestUri = URI.create(this.baseUri + ContainerUtils.encodeUnsafeCharacters((String)s));
        ContainerRequest requestContext = new ContainerRequest(this.baseUri, requestUri, req.method().name(), this.getSecurityContext(), new PropertiesDelegate(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            public Object getProperty(String name) {
                return this.properties.get(name);
            }

            public Collection<String> getPropertyNames() {
                return this.properties.keySet();
            }

            public void setProperty(String name, Object object) {
                this.properties.put(name, object);
            }

            public void removeProperty(String name) {
                this.properties.remove(name);
            }
        });
        if (req.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && HttpUtil.getContentLength((HttpMessage)req) > 0L || HttpUtil.isTransferEncodingChunked((HttpMessage)req)) {
            ctx.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    JerseyServerHandler.this.isList.add(NettyInputStream.END_OF_INPUT_ERROR);
                }
            });
            requestContext.setEntityStream((InputStream)new NettyInputStream(this.isList));
        } else {
            requestContext.setEntityStream(new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            });
        }
        for (String name : req.headers().names()) {
            requestContext.headers(name, (Iterable)req.headers().getAll(name));
        }
        return requestContext;
    }

    private SecurityContext getSecurityContext() {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return false;
            }

            public Principal getUserPrincipal() {
                return null;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ctx.close();
    }
}

