/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2Codec;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.net.URI;
import org.glassfish.jersey.netty.httpserver.HttpVersionChooser;
import org.glassfish.jersey.netty.httpserver.JerseyHttp2ServerHandler;
import org.glassfish.jersey.netty.httpserver.JerseyServerHandler;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;

class JerseyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final URI baseUri;
    private final SslContext sslCtx;
    private final NettyHttpContainer container;
    private final boolean http2;

    public JerseyServerInitializer(URI baseUri, SslContext sslCtx, NettyHttpContainer container) {
        this(baseUri, sslCtx, container, false);
    }

    public JerseyServerInitializer(URI baseUri, SslContext sslCtx, NettyHttpContainer container, boolean http2) {
        this.baseUri = baseUri;
        this.sslCtx = sslCtx;
        this.container = container;
        this.http2 = http2;
    }

    public void initChannel(SocketChannel ch) {
        if (this.http2) {
            if (this.sslCtx != null) {
                this.configureSsl(ch);
            } else {
                this.configureClearText(ch);
            }
        } else {
            ChannelPipeline p = ch.pipeline();
            if (this.sslCtx != null) {
                p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
            }
            p.addLast(new ChannelHandler[]{new HttpServerCodec()});
            p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
            p.addLast(new ChannelHandler[]{new JerseyServerHandler(this.baseUri, this.container)});
        }
    }

    private void configureSsl(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc()), new HttpVersionChooser(this.baseUri, this.container)});
    }

    private void configureClearText(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        p.addLast(new ChannelHandler[]{sourceCodec});
        p.addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return new Http2ServerUpgradeCodec(new Http2Codec(true, (ChannelHandler)new JerseyHttp2ServerHandler(JerseyServerInitializer.this.baseUri, JerseyServerInitializer.this.container)));
                }
                return null;
            }
        })});
        p.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                ChannelPipeline pipeline = ctx.pipeline();
                ChannelHandlerContext thisCtx = pipeline.context((ChannelHandler)this);
                pipeline.addAfter(thisCtx.name(), null, (ChannelHandler)new JerseyServerHandler(JerseyServerInitializer.this.baseUri, JerseyServerInitializer.this.container));
                pipeline.replace((ChannelHandler)this, null, (ChannelHandler)new ChunkedWriteHandler());
                ctx.fireChannelRead((Object)msg);
            }
        }});
    }
}

