/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.netty.httpserver;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Application;
import java.net.URI;
import org.glassfish.jersey.Beta;
import org.glassfish.jersey.netty.httpserver.JerseyServerInitializer;
import org.glassfish.jersey.netty.httpserver.NettyHttpContainer;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerProvider;

@Beta
public class NettyHttpContainerProvider
implements ContainerProvider {
    public <T> T createContainer(Class<T> type, Application application) throws ProcessingException {
        if (NettyHttpContainer.class == type) {
            return type.cast(new NettyHttpContainer(application));
        }
        return null;
    }

    public static Channel createServer(URI baseUri, ResourceConfig configuration, SslContext sslContext, boolean block) throws ProcessingException {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        final NettyHttpContainer container = new NettyHttpContainer((Application)configuration);
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new JerseyServerInitializer(baseUri, sslContext, container, configuration));
            int port = NettyHttpContainerProvider.getPort(baseUri);
            Channel ch = b.bind(port).sync().channel();
            ch.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup){
                final /* synthetic */ EventLoopGroup val$bossGroup;
                final /* synthetic */ EventLoopGroup val$workerGroup;
                {
                    this.val$bossGroup = eventLoopGroup;
                    this.val$workerGroup = eventLoopGroup2;
                }

                public void operationComplete(Future<? super Void> future) throws Exception {
                    container.getApplicationHandler().onShutdown((Container)container);
                    this.val$bossGroup.shutdownGracefully();
                    this.val$workerGroup.shutdownGracefully();
                }
            });
            if (block) {
                ch.closeFuture().sync();
                return ch;
            }
            return ch;
        }
        catch (InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public static Channel createServer(URI baseUri, ResourceConfig configuration, boolean block) throws ProcessingException {
        return NettyHttpContainerProvider.createServer(baseUri, configuration, null, block);
    }

    public static Channel createHttp2Server(URI baseUri, ResourceConfig configuration, SslContext sslContext) throws ProcessingException {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        final NettyHttpContainer container = new NettyHttpContainer((Application)configuration);
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new JerseyServerInitializer(baseUri, sslContext, container, configuration, true));
            int port = NettyHttpContainerProvider.getPort(baseUri);
            Channel ch = b.bind(port).sync().channel();
            ch.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup){
                final /* synthetic */ EventLoopGroup val$bossGroup;
                final /* synthetic */ EventLoopGroup val$workerGroup;
                {
                    this.val$bossGroup = eventLoopGroup;
                    this.val$workerGroup = eventLoopGroup2;
                }

                public void operationComplete(Future<? super Void> future) throws Exception {
                    container.getApplicationHandler().onShutdown((Container)container);
                    this.val$bossGroup.shutdownGracefully();
                    this.val$workerGroup.shutdownGracefully();
                }
            });
            return ch;
        }
        catch (InterruptedException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private static int getPort(URI uri) {
        if (uri.getPort() == -1) {
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                return 80;
            }
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                return 443;
            }
            throw new IllegalArgumentException("URI scheme must be 'http' or 'https'.");
        }
        return uri.getPort();
    }
}

