/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Module;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.ContainerResponseWriter;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;

public class WebComponent {
    private Application application;

    public WebComponent(WebConfig webConfig) throws ServletException {
        this.application = Application.builder((ResourceConfig)this.createResourceConfig(webConfig, new Module[]{new WebComponentModule()})).build();
    }

    public WebComponent(ResourceConfig resourceConfig) throws ServletException {
        this.application = Application.builder((ResourceConfig)resourceConfig).build();
        this.application.addModules(new Module[]{new WebComponentModule()});
    }

    public int service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Request.RequestBuilder requestBuilder = Requests.from((URI)baseUri, (URI)requestUri, (String)request.getMethod());
        requestBuilder = this.addRequestHeaders(request, requestBuilder);
        requestBuilder = requestBuilder.entity((Object)request.getInputStream());
        Request jaxRsRequest = requestBuilder.build();
        try {
            Writer writer = new Writer(false, response);
            this.application.apply(jaxRsRequest, (ContainerResponseWriter)writer);
            return writer.cResponse.getStatus();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private ResourceConfig createResourceConfig(WebConfig config, Module ... modules) throws ServletException {
        Map<String, Object> initParams = this.getInitParams(config);
        return this.createResourceConfig(config, initParams, modules);
    }

    private ResourceConfig createResourceConfig(WebConfig config, Map<String, Object> initParams, Module ... modules) throws ServletException {
        String JaxrsApplicationClassName = config.getInitParameter("javax.ws.rs.Application");
        if (JaxrsApplicationClassName == null) {
            return this.getDefaultResourceConfig(initParams, config, modules);
        }
        try {
            Class JaxrsApplicationClass = ReflectionHelper.classForNameWithException((String)JaxrsApplicationClassName);
            if (javax.ws.rs.core.Application.class.isAssignableFrom(JaxrsApplicationClass)) {
                return ResourceConfig.builder((Class)JaxrsApplicationClass).addProperties(initParams).build();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            String message = "Resource configuration class, " + JaxrsApplicationClassName + ", could not be loaded";
            throw new ServletException(message, (Throwable)e);
        }
    }

    private Request.RequestBuilder addRequestHeaders(HttpServletRequest request, Request.RequestBuilder builder) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            LinkedList valueList = new LinkedList();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                builder = builder.header(name, values.nextElement());
            }
        }
        return builder;
    }

    private Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    private String[] getPaths(String classpath, ServletContext context) throws ServletException {
        if (classpath == null) {
            String[] paths = new String[]{context.getRealPath("/WEB-INF/lib"), context.getRealPath("/WEB-INF/classes")};
            if (paths[0] != null || paths[1] == null) {
                // empty if block
            }
            return paths;
        }
        String[] virtualPaths = classpath.split(";");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (String virtualPath : virtualPaths) {
            String path;
            if ((virtualPath = virtualPath.trim()).length() == 0 || (path = context.getRealPath(virtualPath)) == null) continue;
            resourcePaths.add(path);
        }
        if (resourcePaths.isEmpty()) {
            // empty if block
        }
        return resourcePaths.toArray(new String[resourcePaths.size()]);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig wc, Module ... modules) throws ServletException {
        String classpath;
        ResourceConfig.Builder resourceConfigBuilder = ResourceConfig.builder();
        resourceConfigBuilder.addProperties(props);
        resourceConfigBuilder.addModules(modules);
        String packages = wc.getInitParameter("jersey.config.server.provider.packages");
        if (packages != null) {
            resourceConfigBuilder.packages(new String[]{packages});
        }
        if ((classpath = wc.getInitParameter("jersey.config.server.provider.classpath")) != null) {
            resourceConfigBuilder.files(new String[]{classpath});
        } else {
            resourceConfigBuilder.addFinder((ResourceFinder)new WebAppResourcesScanner(wc.getServletContext()));
        }
        return resourceConfigBuilder.build();
    }

    private ResourceConfig getWebAppResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        return ResourceConfig.builder().addFinder((ResourceFinder)new WebAppResourcesScanner(webConfig.getServletContext())).build();
    }

    private static final class Writer
    extends OutputStream
    implements ContainerResponseWriter {
        final HttpServletResponse response;
        final boolean useSetStatusOn404;
        Response cResponse;
        long contentLength;
        OutputStream out;
        boolean statusAndHeadersWritten = false;

        Writer(boolean useSetStatusOn404, HttpServletResponse response) {
            this.useSetStatusOn404 = useSetStatusOn404;
            this.response = response;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, Response cResponse) throws IOException {
            this.contentLength = contentLength;
            this.cResponse = cResponse;
            this.statusAndHeadersWritten = false;
            return this;
        }

        public void finish() throws IOException {
            if (this.statusAndHeadersWritten) {
                return;
            }
            this.writeHeaders();
            if (this.cResponse.getStatus() >= 400) {
                if (this.useSetStatusOn404 && this.cResponse.getStatus() == 404) {
                    this.response.setStatus(this.cResponse.getStatus());
                } else {
                    String reason = this.cResponse.getStatusEnum().getReasonPhrase();
                    if (reason == null || reason.isEmpty()) {
                        this.response.sendError(this.cResponse.getStatus());
                    } else {
                        this.response.sendError(this.cResponse.getStatus(), reason);
                    }
                }
            } else {
                this.response.setStatus(this.cResponse.getStatus());
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.initiate();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b.length > 0) {
                this.initiate();
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                this.initiate();
                this.out.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            this.writeStatusAndHeaders();
            if (this.out != null) {
                this.out.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.initiate();
            this.out.close();
        }

        void initiate() throws IOException {
            if (this.out == null) {
                this.writeStatusAndHeaders();
                this.out = this.response.getOutputStream();
            }
        }

        void writeStatusAndHeaders() {
            if (this.statusAndHeadersWritten) {
                return;
            }
            this.writeHeaders();
            this.response.setStatus(this.cResponse.getStatus());
            this.statusAndHeadersWritten = true;
        }

        void writeHeaders() {
            if (this.contentLength != -1L && this.contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)this.contentLength);
            }
            MultivaluedMap headers = this.cResponse.getHeaders().asMap();
            for (Map.Entry e : headers.entrySet()) {
                for (String v : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), v);
                }
            }
        }
    }

    private class WebComponentModule
    extends AbstractModule {
        private WebComponentModule() {
        }

        protected void configure() {
            this.bind(HttpServletRequest.class, new Class[0]).toFactory((Factory)new Factory<HttpServletRequest>(){

                public HttpServletRequest get() throws ComponentException {
                    return null;
                }
            });
            this.bind(HttpServletResponse.class, new Class[0]).toFactory((Factory)new Factory<HttpServletResponse>(){

                public HttpServletResponse get() throws ComponentException {
                    return null;
                }
            });
            this.bind(ServletContext.class, new Class[0]).toFactory((Factory)new Factory<ServletContext>(){

                public ServletContext get() throws ComponentException {
                    return null;
                }
            });
            this.bind(ServletConfig.class, new Class[0]).toFactory((Factory)new Factory<ServletConfig>(){

                public ServletConfig get() throws ComponentException {
                    return null;
                }
            });
            this.bind(WebConfig.class, new Class[0]).toFactory((Factory)new Factory<WebConfig>(){

                public WebConfig get() throws ComponentException {
                    return null;
                }
            });
            this.bind(FilterConfig.class, new Class[0]).toFactory((Factory)new Factory<FilterConfig>(){

                public FilterConfig get() throws ComponentException {
                    return null;
                }
            });
        }
    }
}

