/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.WebComponent;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.WebFilterConfig;
import org.glassfish.jersey.servlet.WebServletConfig;
import org.glassfish.jersey.uri.UriComponent;

public class ServletContainer
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = 3932047066686065219L;
    private transient FilterConfig filterConfig;
    private transient WebComponent webComponent;
    private transient Pattern staticContentPattern;
    private String filterContextPath = null;

    protected void init(WebConfig webConfig) throws ServletException {
        this.webComponent = new WebComponent(webConfig);
    }

    public ServletContainer() {
    }

    public ServletContainer(ResourceConfig resourceConfig) throws ServletException {
        this.webComponent = new WebComponent(resourceConfig);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        this.service(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encodedBasePath;
        int i;
        boolean checkPathInfo;
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        StringBuffer requestURL = request.getRequestURL();
        String requestURI = request.getRequestURI();
        boolean bl = checkPathInfo = pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/");
        if (!checkPathInfo || request.getRequestURI().endsWith("/") || servletPath.substring((i = servletPath.lastIndexOf(47)) + 1).indexOf(46) < 0) {
            // empty if block
        }
        UriBuilder absoluteUriBuilder = UriBuilder.fromUri((String)requestURL.toString());
        String decodedBasePath = pathInfo != null ? request.getContextPath() + servletPath + "/" : request.getContextPath() + "/";
        if (!decodedBasePath.equals(encodedBasePath = UriComponent.encode((String)decodedBasePath, (UriComponent.Type)UriComponent.Type.PATH))) {
            throw new ProcessingException("The servlet context path and/or the servlet path contain characters that are percent encoded");
        }
        URI baseUri = absoluteUriBuilder.replacePath(encodedBasePath).build(new Object[0]);
        String queryParameters = request.getQueryString();
        if (queryParameters == null) {
            queryParameters = "";
        }
        URI requestUri = absoluteUriBuilder.replacePath(requestURI).replaceQuery(queryParameters).build(new Object[0]);
        this.service(baseUri, requestUri, request, response);
    }

    public void destroy() {
        super.destroy();
    }

    public void init() throws ServletException {
        this.init(new WebServletConfig(this));
    }

    public int service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return this.webComponent.service(baseUri, requestUri, request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.init(new WebFilterConfig(filterConfig));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        }
        catch (ClassCastException e) {
            throw new ServletException("non-HTTP request or response");
        }
    }

    public ServletContext getServletContext() {
        if (this.filterConfig != null) {
            return this.filterConfig.getServletContext();
        }
        return super.getServletContext();
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String includeRequestURI;
        if (request.getAttribute("javax.servlet.include.request_uri") != null && !(includeRequestURI = (String)request.getAttribute("javax.servlet.include.request_uri")).equals(request.getRequestURI())) {
            this.doFilter(request, response, chain, includeRequestURI, (String)request.getAttribute("javax.servlet.include.servlet_path"), (String)request.getAttribute("javax.servlet.include.query_string"));
            return;
        }
        this.doFilter(request, response, chain, request.getRequestURI(), request.getServletPath(), request.getQueryString());
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String requestURI, String servletPath, String queryString) throws IOException, ServletException {
        URI requestUri;
        UriBuilder absoluteUriBuilder;
        URI baseUri;
        int status;
        Pattern p = this.getStaticContentPattern();
        if (p != null && p.matcher(servletPath).matches()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.filterContextPath == null || !servletPath.startsWith(this.filterContextPath) || servletPath.length() == this.filterContextPath.length()) {
            // empty if block
        }
        if ((status = this.service(baseUri = this.filterContextPath == null ? absoluteUriBuilder.replacePath(request.getContextPath()).path("/").build(new Object[0]) : absoluteUriBuilder.replacePath(request.getContextPath()).path(this.filterContextPath).path("/").build(new Object[0]), requestUri = (absoluteUriBuilder = UriBuilder.fromUri((String)request.getRequestURL().toString())).replacePath(requestURI).replaceQuery(queryString).build(new Object[0]), request, response)) == 404 && !response.isCommitted()) {
            response.setStatus(200);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected Pattern getStaticContentPattern() {
        return this.staticContentPattern;
    }
}

