/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Module;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.util.CommittingOutputStream;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.server.Application;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;

public class WebComponent {
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private Application application;

    public WebComponent(WebConfig webConfig) throws ServletException {
        this.application = Application.builder((ResourceConfig)this.createResourceConfig(webConfig, new Module[]{new WebComponentModule()})).build();
    }

    public WebComponent(ResourceConfig resourceConfig) throws ServletException {
        this.application = Application.builder((ResourceConfig)resourceConfig).build();
        this.application.addModules(new Module[]{new WebComponentModule()});
    }

    public int service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Request.RequestBuilder requestBuilder = Requests.from((URI)baseUri, (URI)requestUri, (String)request.getMethod());
        requestBuilder = this.addRequestHeaders(request, requestBuilder);
        requestBuilder = requestBuilder.entity((Object)request.getInputStream());
        Request jaxRsRequest = requestBuilder.build();
        try {
            ResponseWriter containerContext = new ResponseWriter(false, request, response);
            this.application.apply(jaxRsRequest, (ContainerResponseWriter)containerContext);
            return containerContext.jerseyResponse.getStatus();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private ResourceConfig createResourceConfig(WebConfig config, Module ... modules) throws ServletException {
        Map<String, Object> initParams = this.getInitParams(config);
        return this.createResourceConfig(config, initParams, modules);
    }

    private ResourceConfig createResourceConfig(WebConfig config, Map<String, Object> initParams, Module ... modules) throws ServletException {
        String JaxrsApplicationClassName = config.getInitParameter("javax.ws.rs.Application");
        if (JaxrsApplicationClassName == null) {
            return this.getDefaultResourceConfig(initParams, config, modules);
        }
        try {
            Class JaxrsApplicationClass = ReflectionHelper.classForNameWithException((String)JaxrsApplicationClassName);
            if (javax.ws.rs.core.Application.class.isAssignableFrom(JaxrsApplicationClass)) {
                return ResourceConfig.builder((Class)JaxrsApplicationClass).addProperties(initParams).build();
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            String message = "Resource configuration class, " + JaxrsApplicationClassName + ", could not be loaded";
            throw new ServletException(message, (Throwable)e);
        }
    }

    private Request.RequestBuilder addRequestHeaders(HttpServletRequest request, Request.RequestBuilder builder) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            LinkedList valueList = new LinkedList();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                builder = builder.header(name, values.nextElement());
            }
        }
        return builder;
    }

    private Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    private String[] getPaths(String classpath, ServletContext context) throws ServletException {
        if (classpath == null) {
            String[] paths = new String[]{context.getRealPath("/WEB-INF/lib"), context.getRealPath("/WEB-INF/classes")};
            if (paths[0] != null || paths[1] == null) {
                // empty if block
            }
            return paths;
        }
        String[] virtualPaths = classpath.split(";");
        ArrayList<String> resourcePaths = new ArrayList<String>();
        for (String virtualPath : virtualPaths) {
            String path;
            if ((virtualPath = virtualPath.trim()).length() == 0 || (path = context.getRealPath(virtualPath)) == null) continue;
            resourcePaths.add(path);
        }
        if (resourcePaths.isEmpty()) {
            // empty if block
        }
        return resourcePaths.toArray(new String[resourcePaths.size()]);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig wc, Module ... modules) throws ServletException {
        String classpath;
        ResourceConfig.Builder resourceConfigBuilder = ResourceConfig.builder();
        resourceConfigBuilder.addProperties(props);
        resourceConfigBuilder.addModules(modules);
        String packages = wc.getInitParameter("jersey.config.server.provider.packages");
        if (packages != null) {
            resourceConfigBuilder.packages(new String[]{packages});
        }
        if ((classpath = wc.getInitParameter("jersey.config.server.provider.classpath")) != null) {
            resourceConfigBuilder.files(new String[]{classpath});
        } else {
            resourceConfigBuilder.addFinder((ResourceFinder)new WebAppResourcesScanner(wc.getServletContext()));
        }
        return resourceConfigBuilder.build();
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private AtomicReference<AsyncContext> asyncContextRef;
        private final OutputStream out;
        private final boolean useSetStatusOn404;
        private Response jerseyResponse;
        private long contentLength;
        private final AtomicBoolean statusAndHeadersWritten;

        ResponseWriter(boolean useSetStatusOn404, HttpServletRequest request, HttpServletResponse response) {
            this.useSetStatusOn404 = useSetStatusOn404;
            this.request = request;
            this.response = response;
            this.out = new CommittingOutputStream(){

                protected void commit() throws IOException {
                    ResponseWriter.this.writeStatusAndHeaders();
                }

                protected OutputStream getOutputStream() throws IOException {
                    return ResponseWriter.this.response.getOutputStream();
                }
            };
            this.statusAndHeadersWritten = new AtomicBoolean(false);
            this.asyncContextRef = new AtomicReference();
        }

        public void suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) throws IllegalStateException {
            AsyncContext asyncContext = this.request.startAsync((ServletRequest)this.request, (ServletResponse)this.response);
            asyncContext.setTimeout(timeUnit.toMillis(timeOut));
            asyncContext.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) throws IOException {
                }

                public void onTimeout(AsyncEvent event) throws IOException {
                    timeoutHandler.onTimeout((ContainerResponseWriter)ResponseWriter.this);
                }

                public void onError(AsyncEvent event) throws IOException {
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                }
            });
            this.asyncContextRef.set(asyncContext);
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            AsyncContext asyncContext = this.asyncContextRef.get();
            if (asyncContext == null) {
                throw new IllegalStateException("Not suspended.");
            }
            asyncContext.setTimeout(timeUnit.toMillis(timeOut));
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, Response jerseyResponse) throws ContainerException {
            this.contentLength = contentLength;
            this.jerseyResponse = jerseyResponse;
            this.statusAndHeadersWritten.set(false);
            return this.out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            block11: {
                if (!this.statusAndHeadersWritten.compareAndSet(false, true)) {
                    return;
                }
                try {
                    this.writeHeaders();
                    int status = this.jerseyResponse.getStatus();
                    if (status >= 400) {
                        if (this.useSetStatusOn404 && status == 404) {
                            this.response.setStatus(status);
                            break block11;
                        }
                        String reason = this.jerseyResponse.getStatusEnum().getReasonPhrase();
                        try {
                            if (reason == null || reason.isEmpty()) {
                                this.response.sendError(status);
                            } else {
                                this.response.sendError(status, reason);
                            }
                            break block11;
                        }
                        catch (IOException ex) {
                            throw new ContainerException("I/O exception occured while sending [" + status + "] error response.", (Throwable)ex);
                        }
                    }
                    this.response.setStatus(status);
                }
                finally {
                    AsyncContext asyncContext = this.asyncContextRef.getAndSet(null);
                    if (asyncContext != null) {
                        asyncContext.complete();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            if (!this.response.isCommitted()) {
                try {
                    this.response.reset();
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.FINER, "Unable to reset cancelled response.", ex);
                }
                finally {
                    AsyncContext asyncContext = this.asyncContextRef.getAndSet(null);
                    if (asyncContext != null) {
                        asyncContext.complete();
                    }
                }
            }
        }

        private void writeStatusAndHeaders() {
            if (!this.statusAndHeadersWritten.compareAndSet(false, true)) {
                return;
            }
            this.writeHeaders();
            this.response.setStatus(this.jerseyResponse.getStatus());
        }

        private void writeHeaders() {
            if (this.contentLength != -1L && this.contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)this.contentLength);
            }
            MultivaluedMap headers = this.jerseyResponse.getHeaders().asMap();
            for (Map.Entry e : headers.entrySet()) {
                for (String v : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), v);
                }
            }
        }
    }

    private class WebComponentModule
    extends AbstractModule {
        private WebComponentModule() {
        }

        protected void configure() {
            this.bind(HttpServletRequest.class, new Class[0]).toFactory((Factory)new Factory<HttpServletRequest>(){

                public HttpServletRequest get() throws ComponentException {
                    return null;
                }
            });
            this.bind(HttpServletResponse.class, new Class[0]).toFactory((Factory)new Factory<HttpServletResponse>(){

                public HttpServletResponse get() throws ComponentException {
                    return null;
                }
            });
            this.bind(ServletContext.class, new Class[0]).toFactory((Factory)new Factory<ServletContext>(){

                public ServletContext get() throws ComponentException {
                    return null;
                }
            });
            this.bind(ServletConfig.class, new Class[0]).toFactory((Factory)new Factory<ServletConfig>(){

                public ServletConfig get() throws ComponentException {
                    return null;
                }
            });
            this.bind(WebConfig.class, new Class[0]).toFactory((Factory)new Factory<WebConfig>(){

                public WebConfig get() throws ComponentException {
                    return null;
                }
            });
            this.bind(FilterConfig.class, new Class[0]).toFactory((Factory)new Factory<FilterConfig>(){

                public FilterConfig get() throws ComponentException {
                    return null;
                }
            });
        }
    }
}

