/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.async;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;

public class AsyncContextDelegateProviderImpl
implements AsyncContextDelegateProvider {
    private static final Logger LOGGER = Logger.getLogger(AsyncContextDelegateProviderImpl.class.getName());

    @Override
    public final AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
        return new ExtensionImpl(request, response);
    }

    private static final class ExtensionImpl
    implements AsyncContextDelegate {
        private static final int NEVER_TIMEOUT_VALUE = -1;
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final AtomicReference<AsyncContext> asyncContextRef;
        private final AtomicBoolean completed;

        private ExtensionImpl(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
            this.asyncContextRef = new AtomicReference();
            this.completed = new AtomicBoolean(false);
        }

        @Override
        public void suspend() throws IllegalStateException {
            if (!this.completed.get() && this.asyncContextRef.get() == null) {
                AsyncContext asyncContext = this.getAsyncContext();
                asyncContext.addListener((AsyncListener)new CompletedAsyncContextListener());
                this.asyncContextRef.set(asyncContext);
            }
        }

        private AsyncContext getAsyncContext() {
            AsyncContext asyncContext;
            if (this.request.isAsyncStarted()) {
                asyncContext = this.request.getAsyncContext();
                try {
                    asyncContext.setTimeout(-1L);
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.FINE, LocalizationMessages.SERVLET_ASYNC_CONTEXT_ALREADY_STARTED(), ex);
                }
            } else {
                asyncContext = this.request.startAsync((ServletRequest)this.request, (ServletResponse)this.response);
                asyncContext.setTimeout(-1L);
            }
            return asyncContext;
        }

        @Override
        public void complete() {
            this.completed.set(true);
            AsyncContext asyncContext = this.asyncContextRef.getAndSet(null);
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }

        @Override
        public boolean isCompleted() {
            return this.completed.get();
        }

        private class CompletedAsyncContextListener
        implements AsyncListener {
            private CompletedAsyncContextListener() {
            }

            public void onComplete(AsyncEvent event) throws IOException {
                ExtensionImpl.this.complete();
            }

            public void onTimeout(AsyncEvent event) throws IOException {
            }

            public void onError(AsyncEvent event) throws IOException {
                ExtensionImpl.this.complete();
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
            }
        }
    }
}

