/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.simple.SimpleContainer;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.SocketConnection;

public final class SimpleContainerFactory {
    private SimpleContainerFactory() {
    }

    public static Closeable create(URI address, ResourceConfig config) throws ProcessingException {
        SimpleContainer container = (SimpleContainer)ContainerFactory.createContainer(SimpleContainer.class, (Application)config);
        return SimpleContainerFactory.create(address, null, container);
    }

    public static Closeable create(URI address, SSLContext context, ResourceConfig config) throws ProcessingException {
        SimpleContainer container = (SimpleContainer)ContainerFactory.createContainer(SimpleContainer.class, (Application)config);
        return SimpleContainerFactory.create(address, context, container);
    }

    public static Closeable create(URI uri, ApplicationHandler appHandler) throws ProcessingException {
        return SimpleContainerFactory.create(uri, null, new SimpleContainer(appHandler));
    }

    public static Closeable create(URI uri, SSLContext context, ApplicationHandler appHandler) throws ProcessingException {
        return SimpleContainerFactory.create(uri, context, new SimpleContainer(appHandler));
    }

    public static Closeable create(URI address, SSLContext context, SimpleContainer container) throws ProcessingException {
        SocketConnection connection;
        int port;
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String scheme = address.getScheme();
        int defaultPort = 80;
        if (context == null) {
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException("The URI scheme should be 'http' when not using SSL");
            }
        } else {
            if (!scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException("The URI scheme should be 'https' when using SSL");
            }
            defaultPort = 143;
        }
        if ((port = address.getPort()) == -1) {
            port = defaultPort;
        }
        InetSocketAddress listen = new InetSocketAddress(port);
        try {
            ContainerServer server = new ContainerServer((Container)container);
            connection = new SocketConnection((Server)server);
            connection.connect((SocketAddress)listen, context);
            container.onServerStart();
        }
        catch (IOException ex) {
            throw new ProcessingException("IOException thrown when trying to create simple server", (Throwable)ex);
        }
        return connection;
    }
}

