/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.simple.SimpleContainer;
import org.glassfish.jersey.simple.SimpleServer;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;

public final class SimpleContainerFactory {
    private SimpleContainerFactory() {
    }

    public static SimpleServer create(URI address, ResourceConfig config) {
        return SimpleContainerFactory.create(address, null, new SimpleContainer((Application)config));
    }

    public static SimpleServer create(URI address, ResourceConfig config, int count, int select) {
        return SimpleContainerFactory.create(address, null, new SimpleContainer((Application)config), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config));
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config, int count, int select) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, final SimpleContainer container) {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<Server, IOException>(){

            public Server get() throws IOException {
                return new ContainerServer((Container)container);
            }
        });
    }

    public static SimpleServer create(URI address, SSLContext context, final SimpleContainer container, final int count, final int select) throws ProcessingException {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<Server, IOException>(){

            public Server get() throws IOException {
                return new ContainerServer((Container)container, count, select);
            }
        });
    }

    private static SimpleServer _create(URI address, SSLContext context, final SimpleContainer container, UnsafeValue<Server, IOException> serverProvider) throws ProcessingException {
        int port;
        if (address == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String scheme = address.getScheme();
        int defaultPort = 80;
        if (context == null) {
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException("The URI scheme should be 'http' when not using SSL");
            }
        } else {
            if (!scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException("The URI scheme should be 'https' when using SSL");
            }
            defaultPort = 143;
        }
        if ((port = address.getPort()) == -1) {
            port = defaultPort;
        }
        InetSocketAddress listen = new InetSocketAddress(port);
        try {
            Server server = (Server)serverProvider.get();
            SocketConnection connection = new SocketConnection(server);
            SocketAddress socketAddr = connection.connect((SocketAddress)listen, context);
            container.onServerStart();
            return new SimpleServer((Connection)connection, socketAddr){
                final /* synthetic */ Connection val$connection;
                final /* synthetic */ SocketAddress val$socketAddr;
                {
                    this.val$connection = connection;
                    this.val$socketAddr = socketAddress;
                }

                @Override
                public void close() throws IOException {
                    container.onServerStop();
                    this.val$connection.close();
                }

                @Override
                public int getPort() {
                    return ((InetSocketAddress)this.val$socketAddr).getPort();
                }
            };
        }
        catch (IOException ex) {
            throw new ProcessingException("IOException thrown when trying to create simple server", (Throwable)ex);
        }
    }
}

