/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.SelectableChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.simpleframework.common.thread.DaemonFactory;
import org.simpleframework.transport.trace.Trace;
import org.simpleframework.transport.trace.TraceAnalyzer;

public class SimpleTraceAnalyzer
implements TraceAnalyzer {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(SimpleTraceAnalyzer.class.getName()), Level.FINEST);
    private final TraceConsumer consumer;
    private final ThreadFactory factory = new DaemonFactory(TraceConsumer.class);
    private final AtomicBoolean active;
    private final AtomicLong count;

    public SimpleTraceAnalyzer() {
        this.consumer = new TraceConsumer();
        this.active = new AtomicBoolean();
        this.count = new AtomicLong();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public Trace attach(SelectableChannel channel) {
        long sequence = this.count.getAndIncrement();
        return new TraceFeeder(channel, sequence);
    }

    public void start() {
        if (this.active.compareAndSet(false, true)) {
            Thread thread = this.factory.newThread(this.consumer);
            thread.start();
        }
    }

    public void stop() {
        this.active.set(false);
    }

    private class TraceRecord {
        private final SelectableChannel channel;
        private final String thread = Thread.currentThread().getName();
        private final Object event;
        private final Object value;
        private final long sequence;

        public TraceRecord(SelectableChannel channel, Object event, Object value, long sequence) {
            this.sequence = sequence;
            this.channel = channel;
            this.event = event;
            this.value = value;
        }

        public String toString() {
            StringWriter builder = new StringWriter();
            PrintWriter writer = new PrintWriter(builder);
            writer.print(this.sequence);
            writer.print(" ");
            writer.print(this.channel);
            writer.print(" (");
            writer.print(this.thread);
            writer.print("): ");
            writer.print(this.event);
            if (this.value != null) {
                if (this.value instanceof Throwable) {
                    writer.print(" -> ");
                    ((Throwable)this.value).printStackTrace(writer);
                } else {
                    writer.print(" -> ");
                    writer.print(this.value);
                }
            }
            writer.close();
            return builder.toString();
        }
    }

    private class TraceFeeder
    implements Trace {
        private final SelectableChannel channel;
        private final long sequence;

        public TraceFeeder(SelectableChannel channel, long sequence) {
            this.sequence = sequence;
            this.channel = channel;
        }

        public void trace(Object event) {
            this.trace(event, null);
        }

        public void trace(Object event, Object value) {
            if (SimpleTraceAnalyzer.this.active.get()) {
                TraceRecord record = new TraceRecord(this.channel, event, value, this.sequence);
                SimpleTraceAnalyzer.this.consumer.consume(record);
            }
        }
    }

    private class TraceConsumer
    implements Runnable {
        private final Queue<TraceRecord> queue = new ConcurrentLinkedQueue<TraceRecord>();

        public void consume(TraceRecord record) {
            this.queue.offer(record);
        }

        @Override
        public void run() {
            try {
                while (SimpleTraceAnalyzer.this.active.get()) {
                    Thread.sleep(1000L);
                    this.drain();
                }
            }
            catch (Exception e) {
                logger.info("Trace analyzer error");
            }
            finally {
                try {
                    this.drain();
                }
                catch (Exception e) {
                    logger.info("Trace analyzer could not drain queue");
                }
                SimpleTraceAnalyzer.this.active.set(false);
            }
        }

        private void drain() {
            while (!this.queue.isEmpty()) {
                TraceRecord record = this.queue.poll();
                if (record == null) continue;
                String message = record.toString();
                logger.info(message);
            }
        }
    }
}

