/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.simpleframework.common.thread.DaemonFactory;
import org.simpleframework.http.Address;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;

public final class SimpleContainer
implements org.simpleframework.http.core.Container,
Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(SimpleContainer.class.getName()), Level.FINEST);
    private final Type RequestTYPE = new GenericType<Ref<Request>>(){}.getType();
    private final Type ResponseTYPE = new GenericType<Ref<Response>>(){}.getType();
    private volatile ScheduledExecutorService scheduler;
    private volatile ApplicationHandler appHandler;

    public void handle(Request request, Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response, this.scheduler);
        URI baseUri = this.getBaseUri(request);
        URI requestUri = this.getRequestUri(request, baseUri);
        try {
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod(), this.getSecurityContext(request), (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)this.appHandler.getConfiguration());
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getNames()) {
                requestContext.headers(headerName, new Object[]{request.getValue(headerName)});
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(injectionManager -> {
                ((Ref)injectionManager.getInstance(this.RequestTYPE)).set((Object)request);
                ((Ref)injectionManager.getInstance(this.ResponseTYPE)).set((Object)response);
            });
            this.appHandler.handle(requestContext);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (!responseWriter.isSuspended()) {
                this.close(response);
            }
        }
    }

    private URI getRequestUri(Request request, URI baseUri) {
        try {
            String serverAddress = this.getServerAddress(baseUri);
            String uri = ContainerUtils.getHandlerPath((String)request.getTarget());
            String queryString = request.getQuery().toString();
            if (queryString != null) {
                uri = uri + "?" + ContainerUtils.encodeUnsafeCharacters((String)queryString);
            }
            return new URI(serverAddress + uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getServerAddress(URI baseUri) throws URISyntaxException {
        return new URI(baseUri.getScheme(), null, baseUri.getHost(), baseUri.getPort(), null, null, null).toString();
    }

    private URI getBaseUri(Request request) {
        try {
            String hostHeader = request.getValue("Host");
            if (hostHeader != null) {
                String scheme = request.isSecure() ? "https" : "http";
                return new URI(scheme + "://" + hostHeader + "/");
            }
            Address address = request.getAddress();
            return new URI(address.getScheme(), null, address.getDomain(), address.getPort(), "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return null;
            }

            public String getAuthenticationScheme() {
                return null;
            }
        };
    }

    private void close(Response response) {
        try {
            response.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration.register((Object)new SimpleBinder()));
        this.scheduler = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DaemonFactory(TimeoutDispatcher.class));
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    void onServerStart() {
        this.appHandler.onStartup((Container)this);
    }

    void onServerStop() {
        this.appHandler.onShutdown((Container)this);
        this.scheduler.shutdown();
    }

    SimpleContainer(Application application, Object parentContext) {
        this.appHandler = new ApplicationHandler(application, (Binder)new SimpleBinder(), parentContext);
        this.scheduler = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DaemonFactory(TimeoutDispatcher.class));
    }

    SimpleContainer(Application application) {
        this.appHandler = new ApplicationHandler(application, (Binder)new SimpleBinder());
        this.scheduler = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DaemonFactory(TimeoutDispatcher.class));
    }

    SimpleContainer(Class<? extends Application> applicationClass) {
        this.appHandler = new ApplicationHandler(applicationClass, (Binder)new SimpleBinder());
        this.scheduler = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new DaemonFactory(TimeoutDispatcher.class));
    }

    private static final class TimeoutDispatcher
    implements Runnable {
        private final ResponseWriter writer;
        private final ContainerResponseWriter.TimeoutHandler handler;

        public TimeoutDispatcher(ResponseWriter writer, ContainerResponseWriter.TimeoutHandler handler) {
            this.writer = writer;
            this.handler = handler;
        }

        @Override
        public void run() {
            try {
                this.handler.onTimeout((ContainerResponseWriter)this.writer);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Failed to call timeout handler", (Throwable)e);
            }
        }
    }

    private static final class TimeoutTimer {
        private final AtomicReference<ScheduledFuture<?>> reference = new AtomicReference();
        private final ScheduledExecutorService service;
        private final TimeoutDispatcher task;

        public TimeoutTimer(ScheduledExecutorService service, ScheduledFuture<?> future, TimeoutDispatcher task) {
            this.service = service;
            this.task = task;
        }

        public void reschedule(long timeOut, TimeUnit timeUnit) {
            ScheduledFuture<?> future = this.reference.getAndSet(null);
            if (future != null) {
                if (future.cancel(false)) {
                    future = this.service.schedule(this.task, timeOut == 0L ? Integer.MAX_VALUE : timeOut, timeOut == 0L ? TimeUnit.SECONDS : timeUnit);
                    this.reference.set(future);
                }
            } else {
                future = this.service.schedule(this.task, timeOut == 0L ? Integer.MAX_VALUE : timeOut, timeOut == 0L ? TimeUnit.SECONDS : timeUnit);
                this.reference.set(future);
            }
        }
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final AtomicReference<TimeoutTimer> reference = new AtomicReference();
        private final ScheduledExecutorService scheduler;
        private final Response response;

        ResponseWriter(Response response, ScheduledExecutorService scheduler) {
            this.response = response;
            this.scheduler = scheduler;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            Response.StatusType statusInfo = context.getStatusInfo();
            int code = statusInfo.getStatusCode();
            String reason = statusInfo.getReasonPhrase() == null ? Status.getDescription((int)code) : statusInfo.getReasonPhrase();
            this.response.setCode(code);
            this.response.setDescription(reason);
            if (contentLength != -1L) {
                this.response.setContentLength(contentLength);
            }
            for (Map.Entry e : context.getStringHeaders().entrySet()) {
                for (String value : (List)e.getValue()) {
                    this.response.addValue((String)e.getKey(), value);
                }
            }
            try {
                return this.response.getOutputStream();
            }
            catch (IOException ioe) {
                throw new ContainerException("Error during writing out the response headers.", (Throwable)ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                TimeoutTimer timer = this.reference.get();
                if (timer == null) {
                    TimeoutDispatcher task = new TimeoutDispatcher(this, timeoutHandler);
                    ScheduledFuture<?> future = this.scheduler.schedule(task, timeOut == 0L ? Integer.MAX_VALUE : timeOut, timeOut == 0L ? TimeUnit.SECONDS : timeUnit);
                    timer = new TimeoutTimer(this.scheduler, future, task);
                    this.reference.set(timer);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IllegalStateException ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                logger.debugLog("suspend(...) called");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                TimeoutTimer timer = this.reference.get();
                if (timer == null) {
                    throw new IllegalStateException("Response has not been suspended");
                }
                timer.reschedule(timeOut, timeUnit);
            }
            finally {
                logger.debugLog("setTimeout(...) called");
            }
        }

        public void commit() {
            try {
                this.response.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to send 500 error response.", (Throwable)e);
            }
            finally {
                logger.debugLog("commit() called");
            }
        }

        public boolean isSuspended() {
            return this.reference.get() != null;
        }

        public void failure(Throwable error) {
            try {
                if (!this.response.isCommitted()) {
                    this.response.setCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    this.response.setDescription(error.getMessage());
                }
            }
            finally {
                logger.debugLog("failure(...) called");
                this.commit();
                this.rethrow(error);
            }
        }

        public boolean enableResponseBuffering() {
            return false;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class SimpleBinder
    extends AbstractBinder {
        private SimpleBinder() {
        }

        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(SimpleRequestReferencingFactory.class).to(Request.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Request>>(){})).in(RequestScoped.class);
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(SimpleResponseReferencingFactory.class).to(Response.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Response>>(){})).in(RequestScoped.class);
        }
    }

    private static class SimpleResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public SimpleResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class SimpleRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public SimpleRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

