/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.simple.SimpleContainer;
import org.glassfish.jersey.simple.SimpleServer;
import org.glassfish.jersey.simple.SimpleTraceAnalyzer;
import org.glassfish.jersey.simple.internal.LocalizationMessages;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.simpleframework.transport.trace.TraceAnalyzer;

public final class SimpleContainerFactory {
    private SimpleContainerFactory() {
    }

    public static SimpleServer create(URI address, ResourceConfig config) {
        return SimpleContainerFactory.create(address, null, new SimpleContainer((Application)config));
    }

    public static SimpleServer create(URI address, ResourceConfig config, int count, int select) {
        return SimpleContainerFactory.create(address, null, new SimpleContainer((Application)config), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config));
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config, int count, int select) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, final SimpleContainer container) {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<SocketProcessor, IOException>(){

            public SocketProcessor get() throws IOException {
                return new ContainerSocketProcessor((Container)container);
            }
        }, true);
    }

    public static SimpleServer create(URI address, SSLContext context, final SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication, final SimpleContainer container, boolean start) {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<SocketProcessor, IOException>(){

            public SocketProcessor get() throws IOException {
                return new ContainerSocketProcessor(container){

                    public final void process(Socket socket) throws IOException {
                        SSLEngine sslEngine = socket.getEngine();
                        if (sslEngine != null) {
                            switch (sslClientAuthentication) {
                                case MANDATORY: {
                                    sslEngine.setNeedClientAuth(true);
                                    break;
                                }
                                case OPTIONAL: {
                                    sslEngine.setWantClientAuth(true);
                                    break;
                                }
                                default: {
                                    sslEngine.setNeedClientAuth(false);
                                }
                            }
                        }
                        super.process(socket);
                    }
                };
            }
        }, start);
    }

    public static SimpleServer create(URI address, SSLContext context, ResourceConfig config, Object parentContext, int count, int select) {
        return SimpleContainerFactory.create(address, context, new SimpleContainer((Application)config, parentContext), count, select);
    }

    public static SimpleServer create(URI address, SSLContext context, final SimpleContainer container, final int count, final int select) throws ProcessingException {
        return SimpleContainerFactory._create(address, context, container, new UnsafeValue<SocketProcessor, IOException>(){

            public SocketProcessor get() throws IOException {
                return new ContainerSocketProcessor((Container)container, count, select);
            }
        }, true);
    }

    private static SimpleServer _create(URI address, SSLContext context, SimpleContainer container, UnsafeValue<SocketProcessor, IOException> serverProvider, boolean start) throws ProcessingException {
        int port;
        if (address == null) {
            throw new IllegalArgumentException(LocalizationMessages.URI_CANNOT_BE_NULL());
        }
        String scheme = address.getScheme();
        int defaultPort = 80;
        if (context == null) {
            if (!scheme.equalsIgnoreCase("http")) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTP());
            }
        } else {
            if (!scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException(LocalizationMessages.WRONG_SCHEME_WHEN_USING_HTTPS());
            }
            defaultPort = 443;
        }
        if ((port = address.getPort()) == -1) {
            port = defaultPort;
        }
        final InetSocketAddress listen = new InetSocketAddress(port);
        try {
            SimpleTraceAnalyzer analyzer = new SimpleTraceAnalyzer();
            SocketProcessor server = (SocketProcessor)serverProvider.get();
            SocketConnection connection = new SocketConnection(server, (TraceAnalyzer)analyzer);
            SimpleServer simpleServer = new SimpleServer((Connection)connection, context, container, analyzer){
                private InetSocketAddress socketAddr;
                final /* synthetic */ Connection val$connection;
                final /* synthetic */ SSLContext val$context;
                final /* synthetic */ SimpleContainer val$container;
                final /* synthetic */ SimpleTraceAnalyzer val$analyzer;
                {
                    this.val$connection = connection;
                    this.val$context = sSLContext;
                    this.val$container = simpleContainer;
                    this.val$analyzer = simpleTraceAnalyzer;
                    this.socketAddr = listen;
                }

                @Override
                public final void start() throws IOException {
                    this.socketAddr = (InetSocketAddress)this.val$connection.connect((SocketAddress)listen, this.val$context);
                    this.val$container.onServerStart();
                }

                @Override
                public void close() throws IOException {
                    this.val$container.onServerStop();
                    this.val$analyzer.stop();
                    this.val$connection.close();
                    this.socketAddr = listen;
                }

                @Override
                public int getPort() {
                    return this.socketAddr.getPort();
                }

                @Override
                public boolean isDebug() {
                    return this.val$analyzer.isActive();
                }

                @Override
                public void setDebug(boolean enable) {
                    if (enable) {
                        this.val$analyzer.start();
                    } else {
                        this.val$analyzer.stop();
                    }
                }
            };
            if (start) {
                simpleServer.start();
            }
            return simpleServer;
        }
        catch (IOException ex) {
            throw new ProcessingException(LocalizationMessages.ERROR_WHEN_CREATING_SERVER(), (Throwable)ex);
        }
    }
}

