/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Feature;
import org.glassfish.jersey.FeaturesAndProperties;

public class Configuration
implements javax.ws.rs.client.Configuration,
FeaturesAndProperties {
    private State state;

    Configuration() {
        this.state = new State();
    }

    Configuration(javax.ws.rs.client.Configuration that) {
        this();
    }

    private Configuration(State state) {
        this.state = state;
    }

    Configuration snapshot() {
        this.state.enableCopyOnChange();
        return new Configuration(this.state);
    }

    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    public boolean isProperty(String name) {
        return this.state.isProperty(name);
    }

    public Set<Feature> getFeatures() {
        return this.state.getFeatures();
    }

    public boolean isEnabled(Class<? extends Feature> feature) {
        return this.state.isEnabled(feature);
    }

    public Set<Class<?>> getProviderClasses() {
        return this.state.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.state.getProviderInstances();
    }

    public Configuration update(javax.ws.rs.client.Configuration configuration) {
        this.state = this.state.update(configuration);
        return this;
    }

    public Configuration register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    public Configuration register(Object provider) {
        this.state = this.state.register(provider);
        return this;
    }

    public Configuration enable(Class<? extends Feature> feature) {
        this.state = this.state.enable((Class)feature);
        return this;
    }

    public Configuration enable(Feature feature) {
        this.state = this.state.enable(feature);
        return this;
    }

    public Configuration disable(Class<? extends Feature> feature) {
        this.state = this.state.disable((Class)feature);
        return this;
    }

    public Configuration setProperties(Map<String, ? extends Object> properties) {
        this.state = this.state.setProperties((Map)properties);
        return this;
    }

    public Configuration setProperty(String name, Object value) {
        this.state = this.state.setProperty(name, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements javax.ws.rs.client.Configuration {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private transient StateChangeStrategy strategy = IDENTITY;
        private final Map<String, Object> properties;
        private final Map<String, Object> immutablePropertiesView;
        private final Set<Class<?>> providerClasses;
        private final Set<Object> providerInstances;

        public State() {
            this.properties = new HashMap<String, Object>();
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.providerClasses = new LinkedHashSet();
            this.providerInstances = new LinkedHashSet<Object>();
        }

        private State(State original) {
            this.properties = new HashMap<String, Object>(original.properties);
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.providerClasses = new LinkedHashSet(original.providerClasses);
            this.providerInstances = new LinkedHashSet<Object>(original.providerInstances);
        }

        private State copy() {
            return new State(this);
        }

        public void enableCopyOnChange() {
            this.strategy = COPY_ON_CHANGE;
        }

        public Map<String, Object> getProperties() {
            return this.immutablePropertiesView;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public boolean isProperty(String name) {
            if (this.properties.containsKey(name)) {
                Object value = this.properties.get(name);
                if (value instanceof Boolean) {
                    return (Boolean)Boolean.class.cast(value);
                }
                return Boolean.parseBoolean(value.toString());
            }
            return false;
        }

        public Set<Feature> getFeatures() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isEnabled(Class<? extends Feature> feature) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<Class<?>> getProviderClasses() {
            return this.providerClasses;
        }

        public Set<Object> getProviderInstances() {
            return this.providerInstances;
        }

        public State update(javax.ws.rs.client.Configuration configuration) {
            return new State(((Configuration)configuration).state);
        }

        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.providerClasses.add(providerClass);
            return state;
        }

        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.providerInstances.add(provider);
            return state;
        }

        public State enable(Class<? extends Feature> feature) {
            State state = this.strategy.onChange(this);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public State enable(Feature feature) {
            State state = this.strategy.onChange(this);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public State disable(Class<? extends Feature> feature) {
            State state = this.strategy.onChange(this);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public State setProperties(Map<String, ? extends Object> properties) {
            State state = this.strategy.onChange(this);
            state.properties.clear();
            state.properties.putAll(properties);
            return state;
        }

        public State setProperty(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.properties.put(name, value);
            return state;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof State)) {
                return false;
            }
            State other = (State)obj;
            return (this.properties == other.properties || this.properties != null && ((Object)this.properties).equals(other.properties)) && (this.providerClasses == other.providerClasses || this.providerClasses != null && ((Object)this.providerClasses).equals(other.providerClasses)) && (this.providerInstances == other.providerInstances || this.providerInstances != null && ((Object)this.providerInstances).equals(other.providerInstances));
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.properties != null ? ((Object)this.properties).hashCode() : 0);
            hash = 41 * hash + (this.providerClasses != null ? ((Object)this.providerClasses).hashCode() : 0);
            hash = 41 * hash + (this.providerInstances != null ? ((Object)this.providerInstances).hashCode() : 0);
            return hash;
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

