/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.SettableFuture;
import java.net.URI;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.RequestHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.TypeLiteral;
import org.glassfish.jersey.client.Client;
import org.glassfish.jersey.client.Configuration;
import org.glassfish.jersey.message.internal.Requests;

public class Invocation
implements javax.ws.rs.client.Invocation {
    private final Request request;
    private final Configuration configuration;
    private final Client client;

    private Invocation(Builder builder) {
        this.request = builder.request.build();
        this.configuration = builder.configuration.snapshot();
        this.client = builder.client;
    }

    public Response invoke() throws InvocationException {
        final SettableFuture responseFuture = SettableFuture.create();
        this.client.submit(this, (InvocationCallback<? super Response>)new InvocationCallback<Response>(){

            public void completed(Response response) {
                responseFuture.set((Object)response);
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
            }
        });
        try {
            return (Response)responseFuture.get();
        }
        catch (InterruptedException ex) {
            throw new ClientException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            throw new ClientException(ex.getCause());
        }
    }

    public <T> T invoke(final Class<T> responseType) throws InvocationException {
        final SettableFuture responseFuture = SettableFuture.create();
        this.client.submit(this, (InvocationCallback<? super Response>)new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (responseType == Response.class) {
                    responseFuture.set(responseType.cast(response));
                }
                if (response.getStatus() < 300) {
                    responseFuture.set(response.readEntity(responseType));
                }
                throw new InvocationException(response, true);
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
            }
        });
        try {
            return (T)responseFuture.get();
        }
        catch (InterruptedException ex) {
            throw new ClientException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            throw new ClientException(ex.getCause());
        }
    }

    public <T> T invoke(final TypeLiteral<T> responseType) throws InvocationException {
        final SettableFuture responseFuture = SettableFuture.create();
        this.client.submit(this, (InvocationCallback<? super Response>)new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() < 300) {
                    responseFuture.set(response.readEntity(responseType));
                }
                throw new InvocationException(response, true);
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
            }
        });
        try {
            return (T)responseFuture.get();
        }
        catch (InterruptedException ex) {
            throw new ClientException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            throw new ClientException(ex.getCause());
        }
    }

    public Future<Response> submit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T> Future<T> submit(Class<T> responseType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T> Future<T> submit(TypeLiteral<T> responseType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <T> Future<T> submit(InvocationCallback<T> callback) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Configuration configuration() {
        return this.configuration;
    }

    Request request() {
        return this.request;
    }

    private static class AsyncInvoker
    implements javax.ws.rs.client.AsyncInvoker {
        private final Builder builder;

        private AsyncInvoker(Builder request) {
            this.builder = request;
        }

        public Future<Response> get() throws InvocationException {
            return this.method("GET");
        }

        public <T> Future<T> get(Class<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(TypeLiteral<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(InvocationCallback<T> callback) {
            return this.method("GET", callback);
        }

        public Future<Response> put(Entity<?> entity) throws InvocationException {
            return this.method("PUT", entity);
        }

        public <T> Future<T> put(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("PUT", entity, callback);
        }

        public Future<Response> post(Entity<?> entity) throws InvocationException {
            return this.method("POST", entity);
        }

        public <T> Future<T> post(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("POST", entity, callback);
        }

        public Future<Response> delete() throws InvocationException {
            return this.method("DELETE");
        }

        public <T> Future<T> delete(Class<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(TypeLiteral<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(InvocationCallback<T> callback) {
            return this.method("DELETE", callback);
        }

        public Future<Response> head() throws InvocationException {
            return this.method("HEAD");
        }

        public Future<Response> head(InvocationCallback<Response> callback) {
            return this.method("HEAD", callback);
        }

        public Future<Response> options() throws InvocationException {
            return this.method("OPTIONS");
        }

        public <T> Future<T> options(Class<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(TypeLiteral<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(InvocationCallback<T> callback) {
            return this.method("OPTIONS", callback);
        }

        public Future<Response> trace(Entity<?> entity) throws InvocationException {
            return this.method("TRACE", entity);
        }

        public <T> Future<T> trace(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public <T> Future<T> trace(Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public <T> Future<T> trace(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("TRACE", entity, callback);
        }

        public Future<Response> method(String name) throws InvocationException {
            this.builder.request.method(name);
            return new Invocation(this.builder).submit();
        }

        public <T> Future<T> method(String name, Class<T> responseType) throws InvocationException {
            this.builder.request.method(name);
            return new Invocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, TypeLiteral<T> responseType) throws InvocationException {
            this.builder.request.method(name);
            return new Invocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, InvocationCallback<T> callback) {
            this.builder.request.method(name);
            return new Invocation(this.builder).submit(callback);
        }

        public Future<Response> method(String name, Entity<?> entity) throws InvocationException {
            this.builder.request.method(name);
            this.builder.storeEntity(entity);
            return new Invocation(this.builder).submit();
        }

        public <T> Future<T> method(String name, Entity<?> entity, Class<T> responseType) throws InvocationException {
            this.builder.request.method(name);
            this.builder.storeEntity(entity);
            return new Invocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            this.builder.request.method(name);
            this.builder.storeEntity(entity);
            return new Invocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, Entity<?> entity, InvocationCallback<T> callback) {
            this.builder.request.method(name);
            this.builder.storeEntity(entity);
            return new Invocation(this.builder).submit(callback);
        }
    }

    public static class Builder
    implements Invocation.Builder {
        private final Request.RequestBuilder request;
        private Configuration configuration;
        private Client client;

        protected Builder(URI uri, Configuration configuration, Client client) {
            this.request = Requests.from((URI)uri, (URI)uri, (String)"");
            this.configuration = configuration;
            this.client = client;
        }

        Request.RequestBuilder request() {
            return this.request;
        }

        private void storeEntity(Entity<?> entity) {
            if (entity != null) {
                this.request.variant(entity.getVariant());
                this.request.entity(entity.getEntity());
            }
        }

        public Invocation build(String method) {
            this.request.method(method);
            return new Invocation(this);
        }

        public Invocation build(String method, Entity<?> entity) {
            this.request.method(method);
            this.storeEntity(entity);
            return new Invocation(this);
        }

        public Invocation buildGet() {
            this.request.method("GET");
            return new Invocation(this);
        }

        public Invocation buildDelete() {
            this.request.method("DELETE");
            return new Invocation(this);
        }

        public Invocation buildPost(Entity<?> entity) {
            this.request.method("POST");
            this.storeEntity(entity);
            return new Invocation(this);
        }

        public Invocation buildPut(Entity<?> entity) {
            this.request.method("PUT");
            this.storeEntity(entity);
            return new Invocation(this);
        }

        public javax.ws.rs.client.AsyncInvoker async() {
            return new AsyncInvoker(this);
        }

        public Builder acceptLanguage(Locale ... locales) {
            this.request.acceptLanguage(locales);
            return this;
        }

        public Builder acceptLanguage(String ... locales) {
            this.request.acceptLanguage(locales);
            return this;
        }

        public Builder cookie(Cookie cookie) {
            this.request.cookie(cookie);
            return this;
        }

        public Builder allow(String ... methods) {
            this.request.allow(methods);
            return this;
        }

        public Builder allow(Set<String> methods) {
            this.request.allow(methods);
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            this.request.cacheControl(cacheControl);
            return this;
        }

        public Builder header(String name, Object value) {
            this.request.header(name, value);
            return this;
        }

        public Builder headers(RequestHeaders headers) {
            this.request.replaceAll(headers);
            return this;
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public Response get() throws InvocationException {
            return this.method("GET");
        }

        public <T> T get(Class<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public <T> T get(TypeLiteral<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public Response put(Entity<?> entity) throws InvocationException {
            return this.method("PUT", entity);
        }

        public <T> T put(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> T put(Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public Response post(Entity<?> entity) throws InvocationException {
            return this.method("POST", entity);
        }

        public <T> T post(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public <T> T post(Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public Response delete() throws InvocationException {
            return this.method("DELETE");
        }

        public <T> T delete(Class<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public <T> T delete(TypeLiteral<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public Response head() throws InvocationException {
            return this.method("HEAD");
        }

        public Response options() throws InvocationException {
            return this.method("OPTIONS");
        }

        public <T> T options(Class<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> T options(TypeLiteral<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public Response trace(Entity<?> entity) throws InvocationException {
            return this.method("TRACE", entity);
        }

        public <T> T trace(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public <T> T trace(Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public Response method(String name) throws InvocationException {
            this.request.method(name);
            return new Invocation(this).invoke();
        }

        public <T> T method(String name, Class<T> responseType) throws InvocationException {
            this.request.method(name);
            return new Invocation(this).invoke(responseType);
        }

        public <T> T method(String name, TypeLiteral<T> responseType) throws InvocationException {
            this.request.method(name);
            return new Invocation(this).invoke(responseType);
        }

        public Response method(String name, Entity<?> entity) throws InvocationException {
            this.request.method(name);
            this.storeEntity(entity);
            return new Invocation(this).invoke();
        }

        public <T> T method(String name, Entity<?> entity, Class<T> responseType) throws InvocationException {
            this.request.method(name);
            this.storeEntity(entity);
            return new Invocation(this).invoke(responseType);
        }

        public <T> T method(String name, Entity<?> entity, TypeLiteral<T> responseType) throws InvocationException {
            this.request.method(name);
            this.storeEntity(entity);
            return new Invocation(this).invoke(responseType);
        }
    }
}

