/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.hk2.HK2;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.client.ClientModule;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.Target;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public class JerseyClient
implements Client {
    private final JerseyConfiguration jerseyConfiguration;
    private final AtomicBoolean closedFlag;
    private RequestInvoker invoker;
    private Inflector<Request, Response> transport;
    private RequestScope requestScope;
    private Services services;

    protected JerseyClient(JerseyConfiguration jerseyConfiguration, Inflector<Request, Response> transport, List<Module> customModules) {
        this.jerseyConfiguration = jerseyConfiguration;
        this.closedFlag = new AtomicBoolean(false);
        this.transport = transport;
        this.initialize(customModules);
    }

    private void initialize(List<Module> customModules) {
        Module[] jerseyModules = new Module[]{new ClientModule(this.transport)};
        if (customModules.isEmpty()) {
            this.services = HK2.get().create(null, jerseyModules);
        } else {
            Object[] customModulesArray = customModules.toArray();
            Module[] modules = new Module[jerseyModules.length + customModulesArray.length];
            System.arraycopy(jerseyModules, 0, modules, 0, jerseyModules.length);
            System.arraycopy(customModulesArray, 0, modules, jerseyModules.length, customModulesArray.length);
            this.services = HK2.get().create(null, modules);
        }
        this.requestScope = (RequestScope)this.services.forContract(RequestScope.class).get();
        this.invoker = (RequestInvoker)this.services.forContract(RequestInvoker.class).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<Response> submit(JerseyInvocation invocation, final javax.ws.rs.client.InvocationCallback<? super Response> callback) {
        try {
            this.requestScope.enter();
            Injector injector = (Injector)this.services.forContract(Injector.class).get();
            References refs = (References)injector.inject(References.class);
            JerseyConfiguration cfg = invocation.configuration();
            ServiceProviders providers = refs.serviceProvidersBuilder.setProviderClasses(cfg.getProviderClasses()).setProviderInstances(cfg.getProviderInstances()).build();
            ExceptionMapperFactory mappers = new ExceptionMapperFactory(providers);
            MessageBodyFactory workers = new MessageBodyFactory(providers);
            ContextResolverFactory resolvers = new ContextResolverFactory(providers);
            refs.configuration.set((Object)cfg);
            refs.serviceProviders.set((Object)providers);
            refs.exceptionMappers.set((Object)mappers);
            refs.messageBodyWorkers.set((Object)workers);
            refs.contextRespolvers.set((Object)resolvers);
            ListenableFuture listenableFuture = this.invoker.apply((Request)injector.inject((Object)invocation.request()), new InvocationCallback(){

                public void result(Response response) {
                    callback.completed((Object)response);
                }

                public void failure(Throwable exception) {
                    callback.failed(new InvocationException(exception.getMessage(), exception));
                }

                public void cancelled() {
                }

                public void suspended(long time, TimeUnit unit, InvocationContext context) {
                }

                public void suspendTimeoutChanged(long time, TimeUnit unit) {
                }

                public void resumed() {
                }
            });
            return listenableFuture;
        }
        finally {
            this.requestScope.exit();
        }
    }

    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    private void checkClosed() {
        Preconditions.checkState((!this.closedFlag.get() ? 1 : 0) != 0, (Object)"Client instance has been closed.");
    }

    public JerseyConfiguration configuration() {
        this.checkClosed();
        return this.jerseyConfiguration;
    }

    public Target target(String uri) throws IllegalArgumentException, NullPointerException {
        this.checkClosed();
        return new Target(uri, this);
    }

    public Target target(URI uri) throws NullPointerException {
        this.checkClosed();
        return new Target(uri, this);
    }

    public Target target(UriBuilder uriBuilder) throws NullPointerException {
        this.checkClosed();
        return new Target(uriBuilder, this);
    }

    public Target target(Link link) throws NullPointerException {
        this.checkClosed();
        return new Target(link, this);
    }

    public Invocation invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.checkClosed();
        String method = link.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot create invocation from link " + link);
        }
        if ("POST".equals(method) || "PUT".equals(method)) {
            throw new IllegalArgumentException("Missing entity in invocation created from link " + link);
        }
        Target t = new Target(link, this);
        List ps = link.getProduces();
        JerseyInvocation.Builder ib = t.request(ps.toArray(new String[ps.size()]));
        return ib.build(method);
    }

    public Invocation invocation(Link link, Entity<?> entity) throws NullPointerException, IllegalArgumentException {
        this.checkClosed();
        String method = link.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot create invocation from link " + link);
        }
        boolean isCompatible = false;
        for (String mt : link.getConsumes()) {
            if (!entity.getMediaType().isCompatible(MediaType.valueOf((String)mt))) continue;
            isCompatible = true;
            break;
        }
        if (!isCompatible) {
            throw new IllegalArgumentException("Entity type incompatible with link produces parameter");
        }
        Target t = new Target(link, this);
        List ps = link.getProduces();
        JerseyInvocation.Builder ib = t.request(ps.toArray(new String[ps.size()]));
        return ib.build(method, (Entity)entity);
    }

    public static class Builder {
        private Inflector<Request, Response> transport;
        private final List<Module> customModules = new LinkedList<Module>();

        Builder() {
        }

        public Builder transport(Inflector<Request, Response> transport) {
            this.transport = transport;
            return this;
        }

        public Builder modules(Module ... modules) {
            if (modules != null && modules.length > 0) {
                Collections.addAll(this.customModules, modules);
            }
            return this;
        }

        public JerseyClient build() {
            return new JerseyClient(new JerseyConfiguration(), this.transport, Collections.<Module>emptyList());
        }

        public JerseyClient build(Configuration configuration) {
            return new JerseyClient(new JerseyConfiguration(configuration), this.transport, this.customModules);
        }
    }

    private static final class References {
        @Inject
        private ServiceProviders.Builder serviceProvidersBuilder;
        @Inject
        private Ref<JerseyConfiguration> configuration;
        @Inject
        private Ref<ServiceProviders> serviceProviders;
        @Inject
        private Ref<ExceptionMappers> exceptionMappers;
        @Inject
        private Ref<MessageBodyWorkers> messageBodyWorkers;
        @Inject
        private Ref<ContextResolvers> contextRespolvers;

        private References() {
        }
    }
}

