/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.RequestWriter;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.CommittingOutputStream;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;

public class HttpUrlConnector
extends RequestWriter
implements Inflector<Request, Response> {
    private static InputStream getInputStream(HttpURLConnection uc) throws IOException {
        if (uc.getResponseCode() < 300) {
            return uc.getInputStream();
        }
        InputStream ein = uc.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    public Response apply(Request request) {
        try {
            return this._apply(request);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Response _apply(final Request request) throws IOException {
        Object entity;
        final HttpURLConnection uc = (HttpURLConnection)request.getUri().toURL().openConnection();
        uc.setRequestMethod(request.getMethod());
        if (uc instanceof HttpsURLConnection) {
            Object o;
            if (request.getProperties().containsKey("jersey.config.client.ssl.hostnameVerifier") && (o = request.getProperties().get("jersey.config.client.ssl.hostnameVerifier")) != null && o instanceof HostnameVerifier) {
                ((HttpsURLConnection)uc).setHostnameVerifier((HostnameVerifier)o);
            }
            if (request.getProperties().containsKey("jersey.config.client.ssl.sslContext") && (o = request.getProperties().get("jersey.config.client.ssl.sslContext")) != null && o instanceof SSLContext) {
                ((HttpsURLConnection)uc).setSSLSocketFactory(((SSLContext)o).getSocketFactory());
            }
        }
        if ((entity = request.getEntity()) != null) {
            Logger logger;
            uc.setDoOutput(true);
            if (request.getMethod().equalsIgnoreCase("GET") && (logger = Logger.getLogger(HttpUrlConnector.class.getName())).isLoggable(Level.INFO)) {
                logger.log(Level.INFO, LocalizationMessages.HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
            }
            this.writeRequestEntity(request, new RequestWriter.RequestEntityWriterListener(){

                public void onRequestEntitySize(long size) {
                    if (size == -1L || size < Integer.MAX_VALUE) {
                        // empty if block
                    }
                }

                @Override
                public OutputStream onGetOutputStream() throws IOException {
                    return new CommittingOutputStream(){

                        protected OutputStream getOutputStream() throws IOException {
                            return uc.getOutputStream();
                        }

                        public void commit() throws IOException {
                            HttpUrlConnector.this.writeOutBoundHeaders((MultivaluedMap<String, String>)request.getHeaders().asMap(), uc);
                        }
                    };
                }
            });
        } else {
            this.writeOutBoundHeaders((MultivaluedMap<String, String>)request.getHeaders().asMap(), uc);
        }
        Response.ResponseBuilder rb = Responses.from((int)uc.getResponseCode(), (Request)request, (InputStream)HttpUrlConnector.getInputStream(uc));
        Responses.fillHeaders((Response.ResponseBuilder)rb, (Map)Maps.filterKeys(uc.getHeaderFields(), (Predicate)Predicates.notNull()));
        return rb.build();
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, String> headers, HttpURLConnection uc) {
        for (String key : headers.keySet()) {
            List headerValues = (List)headers.get((Object)key);
            if (headerValues.size() == 1) {
                uc.setRequestProperty(key, (String)headerValues.get(0));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (String value : headerValues) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append((Object)value);
            }
            uc.setRequestProperty(key, b.toString());
        }
    }
}

