/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.spi.RequestExecutorsProvider;
import org.glassfish.jersey.spi.ResponseExecutorsProvider;

class ClientExecutorsFactory
extends ExecutorsFactory<ClientRequest> {
    private final ExecutorService requestingExecutor = this.getInitialRequestingExecutor(new RequestExecutorsProvider(){

        public ExecutorService getRequestingExecutor() {
            return Executors.newCachedThreadPool();
        }
    });
    private final ExecutorService respondingExecutor = this.getInitialRespondingExecutor(new ResponseExecutorsProvider(){

        public ExecutorService getRespondingExecutor() {
            return Executors.newCachedThreadPool();
        }
    });
    private final ExecutorService sameThreadExecutor = MoreExecutors.sameThreadExecutor();

    @Inject
    public ClientExecutorsFactory(ServiceLocator locator) {
        super(locator);
    }

    public ExecutorService getRequestingExecutor(ClientRequest request) {
        if (request.isAsynchronous()) {
            return this.requestingExecutor;
        }
        return this.sameThreadExecutor;
    }

    public ExecutorService getRespondingExecutor(ClientRequest clientRequest) {
        return this.respondingExecutor;
    }

    public static class ClientExecutorModule
    extends AbstractModule {
        protected void configure() {
            this.bind((Descriptor)BuilderHelper.activeLink(ClientExecutorsFactory.class).to(new TypeLiteral<ExecutorsFactory<ClientRequest>>(){}.getType()).in(Singleton.class).build());
        }
    }
}

