/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.Type;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.client.ClientExecutorsFactory;
import org.glassfish.jersey.client.ClientFilteringStage;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.ProviderBinder;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.Module;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.Utilities;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.ExceptionWrapperInterceptor;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingModules;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.DefaultRespondingContext;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingModule;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.spi.ExceptionMappers;

class ClientModule
extends AbstractModule {
    ClientModule() {
    }

    protected void configure() {
        this.install(new Module[]{new RequestScope.Module(), new ProcessingModule(), new ContextInjectionResolver.Module(), new MessagingModules.MessageBodyProviders(), new MessagingModules.HeaderDelegateProviders(), new ProviderBinder.ProviderBinderModule(), new MessageBodyFactory.Module(RequestScoped.class), new ExceptionMapperFactory.Module(RequestScoped.class), new ContextResolverFactory.Module(RequestScoped.class), new JaxrsProviders.Module(), new ClientFilteringStage.Module(), new ExceptionWrapperInterceptor.Module(), new ClientExecutorsFactory.ClientExecutorModule()});
        this.bind(BuilderHelper.link(ConfigurationInjectionFactory.class).to(Configuration.class).to(FeaturesAndProperties.class).in(RequestScoped.class).buildFactory());
        this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<JerseyConfiguration>>(){}.getType()}));
        this.bind(BuilderHelper.link(RequestContextInjectionFactory.class).to(ClientRequest.class).in(RequestScoped.class).buildFactory());
        this.bind(Utilities.createConstantFactoryDescriptor((Factory)ReferencingFactory.referenceFactory(), RequestScoped.class, null, null, null, (Type[])new Type[]{new TypeLiteral<Ref<ClientRequest>>(){}.getType()}));
        this.bind((Descriptor)BuilderHelper.activeLink(DefaultRespondingContext.class).to(new TypeLiteral<ResponseProcessor.RespondingContext<ClientResponse>>(){}.getType()).in(RequestScoped.class).build());
        this.bind((Descriptor)BuilderHelper.activeLink(ResponseProcessorBuilder.class).to(new TypeLiteral<ResponseProcessor.Builder<ClientResponse>>(){}.getType()).in(Singleton.class).build());
    }

    static class ResponseProcessorBuilder
    implements ResponseProcessor.Builder<ClientResponse> {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Provider<ResponseProcessor.RespondingContext<ClientResponse>> respondingCtxProvider;
        @Inject
        private Provider<ExceptionMappers> exceptionMappersProvider;
        @Inject
        private Provider<ClientRequest> requestContextFactory;

        public ResponseProcessor<ClientResponse> build(Future<ClientResponse> inflectedResponse, SettableFuture<ClientResponse> processedResponse, InvocationCallback<ClientResponse> callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor<ClientResponse>(callback, inflectedResponse, processedResponse, this.respondingCtxProvider, scopeInstance, this.requestScope, this.exceptionMappersProvider){

                protected ClientResponse convertResponse(Response exceptionResponse) {
                    return exceptionResponse == null ? null : new ClientResponse(exceptionResponse.getStatusInfo(), (ClientRequest)((Object)ResponseProcessorBuilder.this.requestContextFactory.get()));
                }
            };
        }
    }

    static final class RequestInvokerBuilder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder<ClientResponse> responseProcessorBuilder;
        @Inject
        private Provider<Ref<InvocationContext>> invocationContextReferenceFactory;
        @Inject
        private ExecutorsFactory<ClientRequest> executorsFactory;

        RequestInvokerBuilder() {
        }

        public RequestInvoker<ClientRequest, ClientResponse> build(Stage<ClientRequest> rootStage) {
            AsyncInflectorAdapter.Builder<ClientRequest, ClientResponse> asyncAdapterBuilder = new AsyncInflectorAdapter.Builder<ClientRequest, ClientResponse>(){

                public AsyncInflectorAdapter<ClientRequest, ClientResponse> create(Inflector<ClientRequest, ClientResponse> wrapped, InvocationCallback<ClientResponse> callback) {
                    return new AsyncInflectorAdapter<ClientRequest, ClientResponse>(wrapped, callback){

                        protected ClientResponse convertResponse(ClientRequest requestContext, Response response) {
                            return new ClientResponse(requestContext, response);
                        }
                    };
                }
            };
            return new RequestInvoker(rootStage, this.requestScope, (AsyncInflectorAdapter.Builder)asyncAdapterBuilder, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<ClientRequest> {
        @Inject
        public RequestContextInjectionFactory(Provider<Ref<ClientRequest>> referenceFactory) {
            super(referenceFactory);
        }

        @RequestScoped
        public ClientRequest provide() {
            return (ClientRequest)((Object)super.provide());
        }
    }

    private static class ConfigurationInjectionFactory
    extends ReferencingFactory<JerseyConfiguration> {
        @Inject
        public ConfigurationInjectionFactory(Provider<Ref<JerseyConfiguration>> referenceFactory) {
            super(referenceFactory);
        }

        @RequestScoped
        public JerseyConfiguration provide() {
            return (JerseyConfiguration)super.provide();
        }
    }
}

