/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.message.internal.InboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class ClientResponse
extends InboundMessageContext
implements ClientResponseContext {
    private Response.StatusType status;
    private final ClientRequest requestContext;

    public ClientResponse(final ClientRequest requestContext, final Response response) {
        this(response.getStatusInfo(), requestContext);
        final Object entity = response.getEntity();
        if (entity != null) {
            InputStream entityStream = new InputStream(){
                ByteArrayInputStream byteArrayInputStream = null;

                @Override
                public int read() throws IOException {
                    if (this.byteArrayInputStream == null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            requestContext.getWorkers().writeTo(entity, entity.getClass(), null, null, response.getMediaType(), response.getMetadata(), requestContext.getPropertiesDelegate(), (OutputStream)baos, null, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    }
                    return this.byteArrayInputStream.read();
                }
            };
            this.setEntityStream(entityStream);
        }
    }

    public ClientResponse(Response.StatusType status, ClientRequest requestContext) {
        this.status = status;
        this.requestContext = requestContext;
        this.setWorkers(requestContext.getWorkers());
    }

    public int getStatus() {
        return this.status.getStatusCode();
    }

    public void setStatus(int code) {
        this.status = Statuses.from((int)code);
    }

    public void setStatusInfo(Response.StatusType status) {
        if (status == null) {
            throw new NullPointerException("Response status must not be 'null'");
        }
        this.status = status;
    }

    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public ClientRequest getRequestContext() {
        return this.requestContext;
    }

    public Map<String, NewCookie> getCookies() {
        return super.getResponseCookies();
    }
}

