/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import javax.inject.Inject;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.ProviderBinder;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;

public class RequestProcessingInitializationStage
implements Function<ClientRequest, ClientRequest> {
    private final ServiceLocator locator;
    private final ProviderBinder providerBinder;

    @Inject
    public RequestProcessingInitializationStage(ServiceLocator locator, ProviderBinder providerBinder) {
        this.locator = locator;
        this.providerBinder = providerBinder;
    }

    public ClientRequest apply(ClientRequest requestContext) {
        References refs = (References)this.locator.createAndInitialize(References.class);
        JerseyConfiguration cfg = requestContext.getConfiguration();
        this.providerBinder.bindClasses(cfg.getProviderClasses());
        this.providerBinder.bindInstances(cfg.getProviderInstances());
        ExceptionMapperFactory mappers = new ExceptionMapperFactory(this.locator);
        MessageBodyFactory workers = new MessageBodyFactory(this.locator);
        ContextResolverFactory resolvers = new ContextResolverFactory(this.locator);
        refs.configuration.set((Object)cfg);
        refs.exceptionMappers.set((Object)mappers);
        refs.messageBodyWorkers.set((Object)workers);
        refs.contextResolvers.set((Object)resolvers);
        refs.requestContextRef.set((Object)requestContext);
        requestContext.setWorkers((MessageBodyWorkers)workers);
        return requestContext;
    }

    private static final class References {
        @Inject
        private Ref<JerseyConfiguration> configuration;
        @Inject
        private Ref<ExceptionMappers> exceptionMappers;
        @Inject
        private Ref<MessageBodyWorkers> messageBodyWorkers;
        @Inject
        private Ref<ContextResolvers> contextResolvers;
        @Inject
        Ref<ClientRequest> requestContextRef;

        private References() {
        }
    }
}

