/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.WebTarget;

public class JerseyClient
implements Client {
    private final AtomicBoolean closedFlag = new AtomicBoolean(false);
    private final ClientConfig configuration;
    private final LinkedBlockingDeque<LifecycleListener> listeners = new LinkedBlockingDeque();

    protected JerseyClient() {
        this.configuration = new ClientConfig(this);
    }

    protected JerseyClient(Configuration configuration) {
        this.configuration = new ClientConfig(this, configuration);
    }

    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
        LifecycleListener listener;
        while ((listener = this.listeners.pollFirst()) != null) {
            listener.onClose();
        }
    }

    public void addListener(LifecycleListener listener) {
        this.checkNotClosed();
        this.listeners.push(listener);
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    void checkNotClosed() throws IllegalStateException {
        Preconditions.checkState((!this.closedFlag.get() ? 1 : 0) != 0, (Object)"Client instance has been closed.");
    }

    public ClientConfig configuration() {
        this.checkNotClosed();
        return this.configuration;
    }

    public WebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)"URI template of the newly created target must not be 'null'.");
        return new WebTarget(uri, this);
    }

    public WebTarget target(URI uri) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)"URI of the newly created target must not be 'null'.");
        return new WebTarget(uri, this);
    }

    public WebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uriBuilder, (Object)"URI builder of the newly created target must not be 'null'.");
        return new WebTarget(uriBuilder, this);
    }

    public WebTarget target(Link link) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link to the newly created target must not be 'null'.");
        return new WebTarget(link, this);
    }

    public JerseyInvocation invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link of the newly created invocation must not be 'null'.");
        String method = link.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot create invocation from link " + link);
        }
        if ("POST".equals(method) || "PUT".equals(method)) {
            throw new IllegalArgumentException("Missing entity in invocation created from link " + link);
        }
        WebTarget t = new WebTarget(link, this);
        List ps = link.getProduces();
        JerseyInvocation.Builder ib = t.request(ps.toArray(new String[ps.size()]));
        return ib.build(method);
    }

    public JerseyInvocation invocation(Link link, Entity<?> entity) throws NullPointerException, IllegalArgumentException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)"Link of the newly created invocation must not be 'null'.");
        String method = link.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot create invocation from link " + link);
        }
        boolean isCompatible = false;
        for (String mt : link.getConsumes()) {
            if (!entity.getMediaType().isCompatible(MediaType.valueOf((String)mt))) continue;
            isCompatible = true;
            break;
        }
        if (!isCompatible) {
            throw new IllegalArgumentException("Entity type incompatible with link produces parameter");
        }
        WebTarget t = new WebTarget(link, this);
        List ps = link.getProduces();
        JerseyInvocation.Builder ib = t.request(ps.toArray(new String[ps.size()]));
        return ib.build(method, (Entity)entity);
    }

    static interface LifecycleListener {
        public void onClose();
    }
}

