/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.client.JerseyClientRequestContext;
import org.glassfish.jersey.client.JerseyClientResponseContext;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.jvnet.hk2.annotations.Inject;

class ClientFilteringStage
extends AbstractChainableStage<JerseyClientRequestContext> {
    private final Factory<ServiceProviders> servicesProvidersFactory;
    private final Factory<ResponseProcessor.RespondingContext<JerseyClientResponseContext>> respondingContextFactory;

    ClientFilteringStage(@Inject Factory<ServiceProviders> servicesProvidersFactory, @Inject Factory<ResponseProcessor.RespondingContext<JerseyClientResponseContext>> respondingContextFactory) {
        this.servicesProvidersFactory = servicesProvidersFactory;
        this.respondingContextFactory = respondingContextFactory;
    }

    public Stage.Continuation<JerseyClientRequestContext> apply(JerseyClientRequestContext requestContext) {
        List requestFilters;
        ServiceProviders serviceProviders = (ServiceProviders)this.servicesProvidersFactory.get();
        List responseFilters = serviceProviders.getAll(ClientResponseFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.DESCENDING));
        if (!responseFilters.isEmpty()) {
            ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push((ChainableStage)new ResponseFilterStage(responseFilters));
        }
        if (!(requestFilters = serviceProviders.getAll(ClientRequestFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.ASCENDING))).isEmpty()) {
            for (ClientRequestFilter filter : requestFilters) {
                try {
                    filter.filter((ClientRequestContext)requestContext);
                    final Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    return Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Inflector<JerseyClientRequestContext, JerseyClientResponseContext>(){

                        public JerseyClientResponseContext apply(JerseyClientRequestContext requestContext) {
                            return new JerseyClientResponseContext(requestContext, abortResponse);
                        }
                    }));
                }
                catch (IOException ex) {
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) {
                        throw new WebApplicationException((Throwable)ex);
                    }
                    throw new WebApplicationException((Throwable)ex, abortResponse);
                }
            }
        }
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Module
    extends AbstractModule {
        Module() {
        }

        protected void configure() {
            this.bind().to(ClientFilteringStage.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<JerseyClientResponseContext> {
        private final List<ClientResponseFilter> filters;

        private ResponseFilterStage(List<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        public Stage.Continuation<JerseyClientResponseContext> apply(JerseyClientResponseContext responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter((ClientRequestContext)responseContext.getRequestContext(), (ClientResponseContext)responseContext);
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex);
            }
            return Stage.Continuation.of((Object)((Object)responseContext), (Stage)this.getDefaultNext());
        }
    }
}

