/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Future;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.FeaturesAndProperties;
import org.glassfish.jersey.client.ClientFilteringStage;
import org.glassfish.jersey.client.JerseyClientRequestContext;
import org.glassfish.jersey.client.JerseyClientResponseContext;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.ServiceProvidersModule;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.ExceptionWrapperInterceptor;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingModules;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.DefaultRespondingContext;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingExecutorsFactory;
import org.glassfish.jersey.process.internal.ProcessingModule;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

class ClientModule
extends AbstractModule {
    ClientModule() {
    }

    protected void configure() {
        this.install(new Module[]{new RequestScope.Module(), new ProcessingModule(), new ContextInjectionResolver.Module(), new MessagingModules.MessageBodyProviders(), new MessagingModules.HeaderDelegateProviders(), new ServiceProvidersModule(RequestScope.class), new MessageBodyFactory.Module(RequestScope.class), new ExceptionMapperFactory.Module(RequestScope.class), new ContextResolverFactory.Module(RequestScope.class), new JaxrsProviders.Module(), new ClientFilteringStage.Module(), new ExceptionWrapperInterceptor.Module()});
        this.bind(Configuration.class, new Class[0]).toFactory(ConfigurationInjectionFactory.class).in(RequestScope.class);
        this.bind(FeaturesAndProperties.class, new Class[0]).toFactory(ConfigurationInjectionFactory.class).in(RequestScope.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<JerseyConfiguration>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind(JerseyClientRequestContext.class, new Class[0]).toFactory(RequestContextInjectionFactory.class).in(RequestScope.class);
        this.bind((TypeLiteral)new TypeLiteral<Ref<JerseyClientRequestContext>>(){}).toFactory(ReferencingFactory.referenceFactory()).in(RequestScope.class);
        this.bind((TypeLiteral)new TypeLiteral<ResponseProcessor.RespondingContext<JerseyClientResponseContext>>(){}).to((TypeLiteral)new TypeLiteral<DefaultRespondingContext<JerseyClientResponseContext>>(){}).in(RequestScope.class);
        this.bind((TypeLiteral)new TypeLiteral<ResponseProcessor.Builder<JerseyClientResponseContext>>(){}).to(ResponseProcessorBuilder.class).in(Singleton.class);
    }

    static class ResponseProcessorBuilder
    implements ResponseProcessor.Builder<JerseyClientResponseContext> {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Factory<ResponseProcessor.RespondingContext<JerseyClientResponseContext>> respondingCtxProvider;
        @Inject
        private Factory<ExceptionMappers> exceptionMappersProvider;
        @Inject
        private Factory<JerseyClientRequestContext> requestContextFactory;

        public ResponseProcessor<JerseyClientResponseContext> build(Future<JerseyClientResponseContext> inflectedResponse, SettableFuture<JerseyClientResponseContext> processedResponse, InvocationCallback<JerseyClientResponseContext> callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor<JerseyClientResponseContext>(callback, inflectedResponse, processedResponse, this.respondingCtxProvider, scopeInstance, this.requestScope, this.exceptionMappersProvider){

                protected JerseyClientResponseContext convertResponse(Response exceptionResponse) {
                    return exceptionResponse == null ? null : new JerseyClientResponseContext(exceptionResponse.getStatusInfo(), (JerseyClientRequestContext)((Object)ResponseProcessorBuilder.this.requestContextFactory.get()));
                }
            };
        }
    }

    static final class RequestInvokerBuilder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder<JerseyClientResponseContext> responseProcessorBuilder;
        @Inject
        private Factory<Ref<InvocationContext>> invocationContextReferenceFactory;
        @Inject
        private ProcessingExecutorsFactory executorsFactory;

        RequestInvokerBuilder() {
        }

        public RequestInvoker<JerseyClientRequestContext, JerseyClientResponseContext> build(Stage<JerseyClientRequestContext> rootStage) {
            AsyncInflectorAdapter.Builder<JerseyClientRequestContext, JerseyClientResponseContext> asyncAdapterBuilder = new AsyncInflectorAdapter.Builder<JerseyClientRequestContext, JerseyClientResponseContext>(){

                public AsyncInflectorAdapter<JerseyClientRequestContext, JerseyClientResponseContext> create(Inflector<JerseyClientRequestContext, JerseyClientResponseContext> wrapped, InvocationCallback<JerseyClientResponseContext> callback) {
                    return new AsyncInflectorAdapter<JerseyClientRequestContext, JerseyClientResponseContext>(wrapped, callback){

                        protected JerseyClientResponseContext convertResponse(JerseyClientRequestContext requestContext, Response response) {
                            return new JerseyClientResponseContext(requestContext, response);
                        }
                    };
                }
            };
            return new RequestInvoker(rootStage, this.requestScope, (AsyncInflectorAdapter.Builder)asyncAdapterBuilder, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<JerseyClientRequestContext> {
        public RequestContextInjectionFactory(@Inject Factory<Ref<JerseyClientRequestContext>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class ConfigurationInjectionFactory
    extends ReferencingFactory<JerseyConfiguration> {
        public ConfigurationInjectionFactory(@Inject Factory<Ref<JerseyConfiguration>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

