/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.JerseyClientRequestContext;
import org.glassfish.jersey.client.JerseyClientResponseContext;
import org.glassfish.jersey.client.RequestWriter;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.internal.HeadersFactory;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;
import org.glassfish.jersey.process.Inflector;

public class HttpUrlConnector
extends RequestWriter
implements Inflector<JerseyClientRequestContext, JerseyClientResponseContext> {
    private static InputStream getInputStream(HttpURLConnection uc) throws IOException {
        if (uc.getResponseCode() < 300) {
            return uc.getInputStream();
        }
        InputStream ein = uc.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    public JerseyClientResponseContext apply(JerseyClientRequestContext request) {
        try {
            return this._apply(request);
        }
        catch (IOException ex) {
            throw new InvocationException(ex.getMessage(), (Throwable)ex);
        }
    }

    private JerseyClientResponseContext _apply(final JerseyClientRequestContext requestContext) throws IOException {
        Object entity;
        final HttpURLConnection uc = (HttpURLConnection)requestContext.getUri().toURL().openConnection();
        uc.setRequestMethod(requestContext.getMethod());
        Map<String, Object> configurationProperties = requestContext.getConfiguration().getProperties();
        uc.setInstanceFollowRedirects((Boolean)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.followRedirects", (Object)true));
        uc.setConnectTimeout((Integer)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.connectTimeout", (Object)0));
        uc.setReadTimeout((Integer)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.readTimeout", (Object)0));
        if (uc instanceof HttpsURLConnection) {
            Object o = configurationProperties.get("jersey.config.client.ssl.hostnameVerifier");
            if (o instanceof HostnameVerifier) {
                ((HttpsURLConnection)uc).setHostnameVerifier((HostnameVerifier)o);
            }
            if ((o = configurationProperties.get("jersey.config.client.ssl.sslContext")) instanceof SSLContext) {
                ((HttpsURLConnection)uc).setSSLSocketFactory(((SSLContext)o).getSocketFactory());
            }
        }
        if ((entity = requestContext.getEntity()) != null) {
            Logger logger;
            uc.setDoOutput(true);
            if (requestContext.getMethod().equalsIgnoreCase("GET") && (logger = Logger.getLogger(HttpUrlConnector.class.getName())).isLoggable(Level.INFO)) {
                logger.log(Level.INFO, LocalizationMessages.HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
            }
            this.writeRequestEntity(requestContext, new RequestWriter.RequestEntityWriterListener(){

                public void onRequestEntitySize(long size) {
                    if (size == -1L || size < Integer.MAX_VALUE) {
                        // empty if block
                    }
                }

                @Override
                public OutboundMessageContext.StreamProvider onGetStreamProvider() throws IOException {
                    return new OutboundMessageContext.StreamProvider(){

                        public OutputStream getOutputStream() throws IOException {
                            return uc.getOutputStream();
                        }

                        public void commit() throws IOException {
                            HttpUrlConnector.this.writeOutBoundHeaders((MultivaluedMap<String, String>)HeadersFactory.getStringHeaders((MultivaluedMap)requestContext.getHeaders()), uc);
                        }
                    };
                }
            });
        } else {
            this.writeOutBoundHeaders((MultivaluedMap<String, String>)HeadersFactory.getStringHeaders((MultivaluedMap)requestContext.getHeaders()), uc);
        }
        JerseyClientResponseContext responseContext = new JerseyClientResponseContext(Statuses.from((int)uc.getResponseCode()), requestContext);
        responseContext.setEntityStream(HttpUrlConnector.getInputStream(uc));
        responseContext.headers(Maps.filterKeys(uc.getHeaderFields(), (Predicate)Predicates.notNull()));
        return responseContext;
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, String> headers, HttpURLConnection uc) {
        for (String key : headers.keySet()) {
            List headerValues = (List)headers.get((Object)key);
            if (headerValues.size() == 1) {
                uc.setRequestProperty(key, (String)headerValues.get(0));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (String value : headerValues) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append((Object)value);
            }
            uc.setRequestProperty(key, b.toString());
        }
    }
}

