/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.hk2.HK2;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.client.ClientFilteringStage;
import org.glassfish.jersey.client.ClientModule;
import org.glassfish.jersey.client.HttpUrlConnector;
import org.glassfish.jersey.client.InboundJaxrsResponse;
import org.glassfish.jersey.client.JerseyClientRequestContext;
import org.glassfish.jersey.client.JerseyClientResponseContext;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.client.WebTarget;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.jvnet.hk2.annotations.Inject;

public class JerseyClient
implements Client {
    private final JerseyConfiguration configuration;
    private final AtomicBoolean closedFlag;
    private Inflector<JerseyClientRequestContext, JerseyClientResponseContext> connector;
    private RequestInvoker<JerseyClientRequestContext, JerseyClientResponseContext> invoker;
    @Inject
    private RequestScope requestScope;

    protected JerseyClient(JerseyConfiguration configuration, Inflector<JerseyClientRequestContext, JerseyClientResponseContext> connector, List<Module> customModules) {
        this.configuration = configuration;
        this.closedFlag = new AtomicBoolean(false);
        this.connector = connector == null ? new HttpUrlConnector() : connector;
        this.initialize(customModules);
    }

    private void initialize(List<Module> customModules) {
        Services services;
        Module[] jerseyModules = new Module[]{new ClientModule()};
        if (customModules.isEmpty()) {
            services = HK2.get().create(null, jerseyModules);
        } else {
            Module[] customModulesArray = customModules.toArray(new Module[customModules.size()]);
            Module[] modules = new Module[jerseyModules.length + customModulesArray.length];
            System.arraycopy(jerseyModules, 0, modules, 0, jerseyModules.length);
            System.arraycopy(customModulesArray, 0, modules, jerseyModules.length, customModulesArray.length);
            services = HK2.get().create(null, modules);
        }
        Injector injector = (Injector)services.forContract(Injector.class).get();
        RequestProcessingInitializationStage workersInitializationStage = (RequestProcessingInitializationStage)injector.inject(RequestProcessingInitializationStage.class);
        ClientFilteringStage filteringStage = (ClientFilteringStage)((Object)injector.inject(ClientFilteringStage.class));
        Stage rootStage = Stages.chain((Function)workersInitializationStage).to((ChainableStage)filteringStage).build(Stages.asStage(this.connector));
        this.invoker = ((ClientModule.RequestInvokerBuilder)injector.inject(ClientModule.RequestInvokerBuilder.class)).build((Stage<JerseyClientRequestContext>)rootStage);
        injector.inject((Object)this);
    }

    void submit(final JerseyClientRequestContext requestContext, final javax.ws.rs.client.InvocationCallback<Response> callback) {
        this.requestScope.runInScope(new Runnable(){

            @Override
            public void run() {
                JerseyClient.this.invoker.apply((Object)requestContext, (InvocationCallback)new InvocationCallback<JerseyClientResponseContext>(){

                    public void result(JerseyClientResponseContext responseContext) {
                        InboundJaxrsResponse jaxrsResponse = new InboundJaxrsResponse(responseContext);
                        callback.completed((Object)jaxrsResponse);
                    }

                    public void failure(Throwable exception) {
                        callback.failed(exception instanceof InvocationException ? (InvocationException)exception : new InvocationException(exception.getMessage(), exception));
                    }

                    public void cancelled() {
                    }

                    public void suspended(long time, TimeUnit unit, InvocationContext context) {
                    }

                    public void suspendTimeoutChanged(long time, TimeUnit unit) {
                    }

                    public void resumed() {
                    }
                });
            }
        });
    }

    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    private void checkClosed() {
        Preconditions.checkState((!this.closedFlag.get() ? 1 : 0) != 0, (Object)"Client instance has been closed.");
    }

    public JerseyConfiguration configuration() {
        this.checkClosed();
        return this.configuration;
    }

    public WebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.checkClosed();
        return new WebTarget(uri, this);
    }

    public WebTarget target(URI uri) throws NullPointerException {
        this.checkClosed();
        return new WebTarget(uri, this);
    }

    public WebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.checkClosed();
        return new WebTarget(uriBuilder, this);
    }

    public WebTarget target(Link link) throws NullPointerException {
        this.checkClosed();
        return new WebTarget(link, this);
    }

    public Invocation invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.checkClosed();
        String method = link.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot create invocation from link " + link);
        }
        if ("POST".equals(method) || "PUT".equals(method)) {
            throw new IllegalArgumentException("Missing entity in invocation created from link " + link);
        }
        WebTarget t = new WebTarget(link, this);
        List ps = link.getProduces();
        JerseyInvocation.Builder ib = t.request(ps.toArray(new String[ps.size()]));
        return ib.build(method);
    }

    public Invocation invocation(Link link, Entity<?> entity) throws NullPointerException, IllegalArgumentException {
        this.checkClosed();
        String method = link.getMethod();
        if (method == null) {
            throw new IllegalArgumentException("Cannot create invocation from link " + link);
        }
        boolean isCompatible = false;
        for (String mt : link.getConsumes()) {
            if (!entity.getMediaType().isCompatible(MediaType.valueOf((String)mt))) continue;
            isCompatible = true;
            break;
        }
        if (!isCompatible) {
            throw new IllegalArgumentException("Entity type incompatible with link produces parameter");
        }
        WebTarget t = new WebTarget(link, this);
        List ps = link.getProduces();
        JerseyInvocation.Builder ib = t.request(ps.toArray(new String[ps.size()]));
        return ib.build(method, (Entity)entity);
    }

    public static class Builder {
        private Inflector<JerseyClientRequestContext, JerseyClientResponseContext> connector;
        private final List<Module> customModules = new LinkedList<Module>();

        Builder() {
        }

        public Builder transport(Inflector<JerseyClientRequestContext, JerseyClientResponseContext> connector) {
            this.connector = connector;
            return this;
        }

        public Builder modules(Module ... modules) {
            if (modules != null && modules.length > 0) {
                Collections.addAll(this.customModules, modules);
            }
            return this;
        }

        public JerseyClient build() {
            return new JerseyClient(new JerseyConfiguration(), this.connector, this.customModules);
        }

        public JerseyClient build(Configuration configuration) {
            JerseyConfiguration jerseyConfiguration = configuration instanceof JerseyConfiguration ? new JerseyConfiguration(configuration) : (JerseyConfiguration)configuration;
            return new JerseyClient(jerseyConfiguration, this.connector, this.customModules);
        }
    }
}

