/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

public class JerseyClientRequestContext
extends OutboundMessageContext
implements ClientRequestContext {
    private final JerseyClient client;
    private final JerseyConfiguration configuration;
    private final PropertiesDelegate propertiesDelegate;
    private URI requestUri;
    private String httpMethod;
    private Response abortResponse;
    private MessageBodyWorkers workers;

    public JerseyClientRequestContext(URI requestUri, JerseyClient client, JerseyConfiguration configuration, PropertiesDelegate propertiesDelegate) {
        this.requestUri = requestUri;
        this.client = client;
        this.configuration = configuration;
        this.propertiesDelegate = propertiesDelegate;
    }

    public JerseyClientRequestContext(JerseyClientRequestContext original) {
        super((OutboundMessageContext)original);
        this.requestUri = original.requestUri;
        this.httpMethod = original.httpMethod;
        this.client = original.client;
        this.workers = original.workers;
        this.configuration = original.configuration.snapshot();
        this.propertiesDelegate = new MapPropertiesDelegate(original.propertiesDelegate);
    }

    public Object getProperty(String name) {
        return this.propertiesDelegate.getProperty(name);
    }

    public Enumeration<String> getPropertyNames() {
        return this.propertiesDelegate.getPropertyNames();
    }

    public void setProperty(String name, Object object) {
        this.propertiesDelegate.setProperty(name, object);
    }

    public void removeProperty(String name) {
        this.propertiesDelegate.removeProperty(name);
    }

    PropertiesDelegate getPropertiesDelegate() {
        return this.propertiesDelegate;
    }

    public URI getUri() {
        return this.requestUri;
    }

    public void setUri(URI uri) {
        this.requestUri = uri;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public void setMethod(String method) {
        this.httpMethod = method;
    }

    public JerseyClient getClient() {
        return this.client;
    }

    public void abortWith(Response response) {
        this.abortResponse = response;
    }

    public Response getAbortResponse() {
        return this.abortResponse;
    }

    public JerseyConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, Cookie> getCookies() {
        return super.getRequestCookies();
    }

    public MessageBodyWorkers getWorkers() {
        return this.workers;
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    public void accept(MediaType ... types) {
        this.headers("Accept", types);
    }

    public void accept(String ... types) {
        this.headers("Accept", types);
    }

    public void acceptLanguage(Locale ... locales) {
        this.headers("Accept-Language", locales);
    }

    public void acceptLanguage(String ... locales) {
        this.headers("Accept-Language", locales);
    }

    public void cookie(Cookie cookie) {
        this.header("Cookie", cookie);
    }

    public void allow(String ... methods) {
        this.headers("Allow", methods);
    }

    public void allow(Set<String> methods) {
        this.headers("Allow", methods);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.header("Cache-Control", cacheControl);
    }

    public void encoding(String encoding) {
        this.replace("Content-Encoding", encoding);
    }

    public void replaceHeaders(MultivaluedMap<String, Object> map) {
        this.replaceAll(map);
    }

    public void language(String language) {
        this.replace("Content-Language", language);
    }

    public void language(Locale language) {
        this.replace("Content-Language", language);
    }

    public void type(MediaType type) {
        this.setMediaType(type);
    }

    public void type(String type) {
        this.type(type == null ? null : MediaType.valueOf((String)type));
    }

    public void variant(Variant variant) {
        if (variant == null) {
            this.type((MediaType)null);
            this.language((String)null);
            this.encoding(null);
        } else {
            this.type(variant.getMediaType());
            this.language(variant.getLanguage());
            this.encoding(variant.getEncoding());
        }
    }
}

