/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Feature;
import org.glassfish.jersey.FeaturesAndProperties;

public class JerseyConfiguration
implements Configuration,
FeaturesAndProperties {
    private State state;

    JerseyConfiguration() {
        this.state = new State();
    }

    JerseyConfiguration(Configuration that) {
        this.state = new State();
        this.state = this.state.setProperties(that.getProperties());
        for (Object provider : that.getProviderInstances()) {
            this.state = this.state.register(provider);
        }
        for (Class providerClass : that.getProviderClasses()) {
            this.state = this.state.register(providerClass);
        }
        for (Feature feature : that.getFeatures()) {
            this.state = this.state.enable(feature);
        }
    }

    private JerseyConfiguration(State state) {
        this.state = state;
    }

    JerseyConfiguration snapshot() {
        this.state.markAsShared();
        return new JerseyConfiguration(this.state);
    }

    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    public boolean isProperty(String name) {
        return this.state.isProperty(name);
    }

    public Set<Feature> getFeatures() {
        return this.state.getFeatures();
    }

    public boolean isEnabled(Class<? extends Feature> feature) {
        return this.state.isEnabled(feature);
    }

    public Set<Class<?>> getProviderClasses() {
        return this.state.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.state.getProviderInstances();
    }

    public JerseyConfiguration update(Configuration configuration) {
        this.state = this.state.update(configuration);
        return this;
    }

    public JerseyConfiguration register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    public JerseyConfiguration register(Object provider) {
        this.state = provider instanceof Feature ? this.state.enable((Feature)provider) : this.state.register(provider);
        return this;
    }

    public JerseyConfiguration setProperties(Map<String, ? extends Object> properties) {
        this.state = this.state.setProperties((Map)properties);
        return this;
    }

    public JerseyConfiguration setProperty(String name, Object value) {
        this.state = this.state.setProperty(name, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JerseyConfiguration other = (JerseyConfiguration)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements Configuration {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private transient StateChangeStrategy strategy = IDENTITY;
        private final Map<String, Object> properties;
        private final Map<String, Object> immutablePropertiesView;
        private final Set<Class<?>> providerClasses;
        private final Set<Object> providerInstances;
        private final BiMap<Class<? extends Feature>, Feature> features;
        private final Set<Feature> featuresSetView;

        public State() {
            this.properties = new HashMap<String, Object>();
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.providerClasses = new LinkedHashSet();
            this.providerInstances = new LinkedHashSet<Object>();
            this.features = HashBiMap.create();
            this.featuresSetView = Collections.unmodifiableSet(this.features.values());
        }

        private State(State original) {
            this.properties = new HashMap<String, Object>(original.properties);
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.providerClasses = new LinkedHashSet(original.providerClasses);
            this.providerInstances = new LinkedHashSet<Object>(original.providerInstances);
            this.features = HashBiMap.create(original.features);
            this.featuresSetView = Collections.unmodifiableSet(this.features.values());
        }

        private State copy() {
            return new State(this);
        }

        public void markAsShared() {
            this.strategy = COPY_ON_CHANGE;
        }

        public Map<String, Object> getProperties() {
            return this.immutablePropertiesView;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public boolean isProperty(String name) {
            if (this.properties.containsKey(name)) {
                Object value = this.properties.get(name);
                if (value instanceof Boolean) {
                    return (Boolean)Boolean.class.cast(value);
                }
                return Boolean.parseBoolean(value.toString());
            }
            return false;
        }

        public Set<Feature> getFeatures() {
            return this.featuresSetView;
        }

        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return this.features.containsKey(featureClass);
        }

        public Set<Class<?>> getProviderClasses() {
            return this.providerClasses;
        }

        public Set<Object> getProviderInstances() {
            return this.providerInstances;
        }

        public State update(Configuration configuration) {
            return new State(((JerseyConfiguration)configuration).state);
        }

        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.providerClasses.add(providerClass);
            return state;
        }

        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.providerInstances.add(provider);
            return state;
        }

        public State enable(Feature feature) {
            Class<?> featureClass = feature.getClass();
            if (this.features.containsKey(featureClass)) {
                throw new IllegalStateException(String.format("Feature [%s] has already been enabled.", featureClass));
            }
            State state = this.strategy.onChange(this);
            boolean success = feature.onEnable((Configuration)state);
            if (success) {
                state.features.put(featureClass, (Object)feature);
            }
            return state;
        }

        public State setProperties(Map<String, ? extends Object> properties) {
            State state = this.strategy.onChange(this);
            state.properties.clear();
            state.properties.putAll(properties);
            return state;
        }

        public State setProperty(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.properties.put(name, value);
            return state;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof State)) {
                return false;
            }
            State other = (State)obj;
            return (this.properties == other.properties || this.properties != null && ((Object)this.properties).equals(other.properties)) && (this.providerClasses == other.providerClasses || this.providerClasses != null && ((Object)this.providerClasses).equals(other.providerClasses)) && (this.providerInstances == other.providerInstances || this.providerInstances != null && ((Object)this.providerInstances).equals(other.providerInstances));
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.properties != null ? ((Object)this.properties).hashCode() : 0);
            hash = 41 * hash + (this.providerClasses != null ? ((Object)this.providerClasses).hashCode() : 0);
            hash = 41 * hash + (this.providerInstances != null ? ((Object)this.providerInstances).hashCode() : 0);
            return hash;
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

