/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientRequestContext;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.jvnet.tiger_types.Types;

public class JerseyInvocation
implements Invocation {
    private final JerseyClientRequestContext requestContext;

    private JerseyInvocation(Builder builder) {
        this.requestContext = new JerseyClientRequestContext(builder.requestContext);
    }

    public Response invoke() throws InvocationException {
        return this.retrieveResponse(this.submit());
    }

    public <T> T invoke(Class<T> responseType) throws InvocationException {
        return this.retrieveResponse(this.submit(responseType));
    }

    public <T> T invoke(GenericType<T> responseType) throws InvocationException {
        return this.retrieveResponse(this.submit(responseType));
    }

    private <T> T retrieveResponse(Future<T> responseFuture) {
        try {
            return responseFuture.get();
        }
        catch (InterruptedException ex) {
            throw new ClientException((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            throw new ClientException(cause);
        }
    }

    public Future<Response> submit() {
        final SettableFuture responseFuture = SettableFuture.create();
        this.requestContext.getClient().submit(this.requestContext, new InvocationCallback<Response>(){

            public void completed(Response response) {
                responseFuture.set((Object)response);
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
            }
        });
        return responseFuture;
    }

    public <T> Future<T> submit(final Class<T> responseType) {
        final SettableFuture responseFuture = SettableFuture.create();
        this.requestContext.getClient().submit(this.requestContext, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (responseType == Response.class) {
                    responseFuture.set(responseType.cast(response));
                    return;
                }
                if (response.getStatus() < 300) {
                    try {
                        Object entity = response.readEntity(responseType);
                        responseFuture.set(entity);
                    }
                    catch (Exception e) {
                        this.failed(e instanceof InvocationException ? (InvocationException)e : new InvocationException(e.getMessage(), (Throwable)e));
                    }
                } else {
                    this.failed(JerseyInvocation.this.convertToException(response));
                }
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
            }
        });
        return responseFuture;
    }

    public <T> Future<T> submit(final GenericType<T> responseType) {
        final SettableFuture responseFuture = SettableFuture.create();
        this.requestContext.getClient().submit(this.requestContext, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() < 300) {
                    try {
                        responseFuture.set(response.readEntity(responseType));
                    }
                    catch (Exception e) {
                        this.failed(new InvocationException(LocalizationMessages.UNEXPECTED_ERROR_RESPONSE_PROCESSING(), (Throwable)e));
                    }
                } else {
                    this.failed(JerseyInvocation.this.convertToException(response));
                }
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
            }
        });
        return responseFuture;
    }

    public <T> Future<T> submit(final InvocationCallback<T> callback) {
        final SettableFuture responseFuture = SettableFuture.create();
        final Type callbackType = Types.getTypeArgument(callback.getClass(), (int)0);
        final Class rawType = Types.erasure((Type)callbackType);
        this.requestContext.getClient().submit(this.requestContext, new InvocationCallback<Response>(){

            public void completed(Response response) {
                if (response.getStatus() < 300) {
                    Object result = rawType == Response.class ? rawType.cast(response) : response.readEntity(new GenericType(callbackType));
                    responseFuture.set(result);
                    callback.completed(result);
                } else {
                    this.failed(JerseyInvocation.this.convertToException(response));
                }
            }

            public void failed(InvocationException error) {
                responseFuture.setException((Throwable)error);
                callback.failed(error);
            }
        });
        return responseFuture;
    }

    private InvocationException convertToException(Response response) {
        try {
            return new InvocationException(response, true);
        }
        catch (Throwable t) {
            return new InvocationException(LocalizationMessages.RESPONSE_TO_EXCEPTION_CONVERSION_FAILED(), t);
        }
    }

    public JerseyConfiguration configuration() {
        return this.requestContext.getConfiguration();
    }

    JerseyClientRequestContext request() {
        return this.requestContext;
    }

    private static class AsyncInvoker
    implements javax.ws.rs.client.AsyncInvoker {
        private final Builder builder;

        private AsyncInvoker(Builder request) {
            this.builder = request;
        }

        public Future<Response> get() throws InvocationException {
            return this.method("GET");
        }

        public <T> Future<T> get(Class<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(GenericType<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public <T> Future<T> get(InvocationCallback<T> callback) {
            return this.method("GET", callback);
        }

        public Future<Response> put(Entity<?> entity) throws InvocationException {
            return this.method("PUT", entity);
        }

        public <T> Future<T> put(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> Future<T> put(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("PUT", entity, callback);
        }

        public Future<Response> post(Entity<?> entity) throws InvocationException {
            return this.method("POST", entity);
        }

        public <T> Future<T> post(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public <T> Future<T> post(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("POST", entity, callback);
        }

        public Future<Response> delete() throws InvocationException {
            return this.method("DELETE");
        }

        public <T> Future<T> delete(Class<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(GenericType<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public <T> Future<T> delete(InvocationCallback<T> callback) {
            return this.method("DELETE", callback);
        }

        public Future<Response> head() throws InvocationException {
            return this.method("HEAD");
        }

        public Future<Response> head(InvocationCallback<Response> callback) {
            return this.method("HEAD", callback);
        }

        public Future<Response> options() throws InvocationException {
            return this.method("OPTIONS");
        }

        public <T> Future<T> options(Class<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(GenericType<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> Future<T> options(InvocationCallback<T> callback) {
            return this.method("OPTIONS", callback);
        }

        public Future<Response> trace(Entity<?> entity) throws InvocationException {
            return this.method("TRACE", entity);
        }

        public <T> Future<T> trace(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public <T> Future<T> trace(Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public <T> Future<T> trace(Entity<?> entity, InvocationCallback<T> callback) {
            return this.method("TRACE", entity, callback);
        }

        public Future<Response> method(String name) throws InvocationException {
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit();
        }

        public <T> Future<T> method(String name, Class<T> responseType) throws InvocationException {
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, GenericType<T> responseType) throws InvocationException {
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, InvocationCallback<T> callback) {
            this.builder.requestContext.setMethod(name);
            return new JerseyInvocation(this.builder).submit(callback);
        }

        public Future<Response> method(String name, Entity<?> entity) throws InvocationException {
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit();
        }

        public <T> Future<T> method(String name, Entity<?> entity, Class<T> responseType) throws InvocationException {
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit(responseType);
        }

        public <T> Future<T> method(String name, Entity<?> entity, InvocationCallback<T> callback) {
            this.builder.requestContext.setMethod(name);
            this.builder.storeEntity(entity);
            return new JerseyInvocation(this.builder).submit(callback);
        }
    }

    public static class Builder
    implements Invocation.Builder {
        private final JerseyClientRequestContext requestContext;

        protected Builder(URI uri, JerseyConfiguration configuration, JerseyClient client) {
            this.requestContext = new JerseyClientRequestContext(uri, client, configuration, (PropertiesDelegate)new MapPropertiesDelegate());
        }

        JerseyClientRequestContext request() {
            return this.requestContext;
        }

        private void storeEntity(Entity<?> entity) {
            if (entity != null) {
                this.requestContext.variant(entity.getVariant());
                this.requestContext.setEntity(entity.getEntity());
            }
        }

        public JerseyInvocation build(String method) {
            this.requestContext.setMethod(method);
            return new JerseyInvocation(this);
        }

        public JerseyInvocation build(String method, Entity<?> entity) {
            this.requestContext.setMethod(method);
            this.storeEntity(entity);
            return new JerseyInvocation(this);
        }

        public JerseyInvocation buildGet() {
            this.requestContext.setMethod("GET");
            return new JerseyInvocation(this);
        }

        public JerseyInvocation buildDelete() {
            this.requestContext.setMethod("DELETE");
            return new JerseyInvocation(this);
        }

        public JerseyInvocation buildPost(Entity<?> entity) {
            this.requestContext.setMethod("POST");
            this.storeEntity(entity);
            return new JerseyInvocation(this);
        }

        public JerseyInvocation buildPut(Entity<?> entity) {
            this.requestContext.setMethod("PUT");
            this.storeEntity(entity);
            return new JerseyInvocation(this);
        }

        public javax.ws.rs.client.AsyncInvoker async() {
            return new AsyncInvoker(this);
        }

        public Builder acceptLanguage(Locale ... locales) {
            this.requestContext.acceptLanguage(locales);
            return this;
        }

        public Builder acceptLanguage(String ... locales) {
            this.requestContext.acceptLanguage(locales);
            return this;
        }

        public Builder cookie(Cookie cookie) {
            this.requestContext.cookie(cookie);
            return this;
        }

        public Builder allow(String ... methods) {
            this.requestContext.allow(methods);
            return this;
        }

        public Builder allow(Set<String> methods) {
            this.requestContext.allow(methods);
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            this.requestContext.cacheControl(cacheControl);
            return this;
        }

        public Builder header(String name, Object value) {
            this.requestContext.header(name, value);
            return this;
        }

        public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
            this.requestContext.replaceHeaders(headers);
            return this;
        }

        public JerseyConfiguration configuration() {
            return this.requestContext.getConfiguration();
        }

        public Response get() throws InvocationException {
            return this.method("GET");
        }

        public <T> T get(Class<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public <T> T get(GenericType<T> responseType) throws InvocationException {
            return this.method("GET", responseType);
        }

        public Response put(Entity<?> entity) throws InvocationException {
            return this.method("PUT", entity);
        }

        public <T> T put(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public <T> T put(Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            return this.method("PUT", entity, responseType);
        }

        public Response post(Entity<?> entity) throws InvocationException {
            return this.method("POST", entity);
        }

        public <T> T post(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public <T> T post(Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            return this.method("POST", entity, responseType);
        }

        public Response delete() throws InvocationException {
            return this.method("DELETE");
        }

        public <T> T delete(Class<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public <T> T delete(GenericType<T> responseType) throws InvocationException {
            return this.method("DELETE", responseType);
        }

        public Response head() throws InvocationException {
            return this.method("HEAD");
        }

        public Response options() throws InvocationException {
            return this.method("OPTIONS");
        }

        public <T> T options(Class<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public <T> T options(GenericType<T> responseType) throws InvocationException {
            return this.method("OPTIONS", responseType);
        }

        public Response trace(Entity<?> entity) throws InvocationException {
            return this.method("TRACE", entity);
        }

        public <T> T trace(Entity<?> entity, Class<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public <T> T trace(Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            return this.method("TRACE", entity, responseType);
        }

        public Response method(String name) throws InvocationException {
            this.requestContext.setMethod(name);
            return new JerseyInvocation(this).invoke();
        }

        public <T> T method(String name, Class<T> responseType) throws InvocationException {
            this.requestContext.setMethod(name);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public <T> T method(String name, GenericType<T> responseType) throws InvocationException {
            this.requestContext.setMethod(name);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public Response method(String name, Entity<?> entity) throws InvocationException {
            this.requestContext.setMethod(name);
            this.storeEntity(entity);
            return new JerseyInvocation(this).invoke();
        }

        public <T> T method(String name, Entity<?> entity, Class<T> responseType) throws InvocationException {
            this.requestContext.setMethod(name);
            this.storeEntity(entity);
            return new JerseyInvocation(this).invoke(responseType);
        }

        public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) throws InvocationException {
            this.requestContext.setMethod(name);
            this.storeEntity(entity);
            return new JerseyInvocation(this).invoke(responseType);
        }
    }
}

