/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.inject.Injector;
import org.glassfish.jersey.client.JerseyClientRequestContext;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.spi.ContextResolvers;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public class RequestProcessingInitializationStage
implements Function<JerseyClientRequestContext, JerseyClientRequestContext> {
    private final Injector injector;
    private final ServiceProviders.Builder serviceProvidersBuilder;

    public RequestProcessingInitializationStage(@Inject Injector injector, @Inject ServiceProviders.Builder serviceProvidersBuilder, @Inject Factory<MessageBodyWorkers> workersFactory) {
        this.injector = injector;
        this.serviceProvidersBuilder = serviceProvidersBuilder;
    }

    public JerseyClientRequestContext apply(JerseyClientRequestContext requestContext) {
        References refs = (References)this.injector.inject(References.class);
        JerseyConfiguration cfg = requestContext.getConfiguration();
        ServiceProviders providers = this.serviceProvidersBuilder.setProviderClasses(cfg.getProviderClasses()).setProviderInstances(cfg.getProviderInstances()).build();
        ExceptionMapperFactory mappers = new ExceptionMapperFactory(providers);
        MessageBodyFactory workers = new MessageBodyFactory(providers);
        ContextResolverFactory resolvers = new ContextResolverFactory(providers);
        refs.configuration.set((Object)cfg);
        refs.serviceProviders.set((Object)providers);
        refs.exceptionMappers.set((Object)mappers);
        refs.messageBodyWorkers.set((Object)workers);
        refs.contextResolvers.set((Object)resolvers);
        refs.requestContextRef.set((Object)requestContext);
        requestContext.setWorkers((MessageBodyWorkers)workers);
        return requestContext;
    }

    private static final class References {
        @Inject
        private Ref<JerseyConfiguration> configuration;
        @Inject
        private Ref<ServiceProviders> serviceProviders;
        @Inject
        private Ref<ExceptionMappers> exceptionMappers;
        @Inject
        private Ref<MessageBodyWorkers> messageBodyWorkers;
        @Inject
        private Ref<ContextResolvers> contextResolvers;
        @Inject
        Ref<JerseyClientRequestContext> requestContextRef;

        private References() {
        }
    }
}

