/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyConfiguration;
import org.glassfish.jersey.client.JerseyInvocation;

public class WebTarget
implements javax.ws.rs.client.WebTarget {
    private final JerseyConfiguration configuration;
    private final UriBuilder targetUri;
    private final Map<String, Object> pathParams;
    private final JerseyClient client;

    WebTarget(String uri, JerseyClient parent) {
        this(UriBuilder.fromUri((String)uri), null, parent.configuration().snapshot(), parent);
    }

    WebTarget(URI uri, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)uri), null, parent.configuration().snapshot(), parent);
    }

    WebTarget(UriBuilder uriBuilder, JerseyClient parent) {
        this(uriBuilder.clone(), null, parent.configuration().snapshot(), parent);
    }

    WebTarget(Link link, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)link.getUri()), null, parent.configuration().snapshot(), parent);
    }

    protected WebTarget(UriBuilder targetUri, WebTarget that) {
        this(targetUri, that.pathParams, that.configuration.snapshot(), that.client);
    }

    protected WebTarget(UriBuilder targetUri, Map<String, Object> pathParams, JerseyConfiguration jerseyConfiguration, JerseyClient client) {
        this.targetUri = targetUri;
        this.pathParams = pathParams != null ? Maps.newHashMap(pathParams) : Maps.newHashMap();
        this.configuration = jerseyConfiguration;
        this.client = client;
    }

    protected final void setPathParam(String name, Object value) {
        if (value == null) {
            this.pathParams.remove(name);
        } else {
            this.pathParams.put(name, value);
        }
    }

    protected final void replacePathParams(Map<String, Object> params) {
        this.pathParams.clear();
        if (params != null) {
            this.pathParams.putAll(params);
        }
    }

    public URI getUri() {
        return this.targetUri.buildFromMap(this.pathParams);
    }

    public UriBuilder getUriBuilder() {
        return this.targetUri.clone();
    }

    public JerseyConfiguration configuration() {
        return this.configuration;
    }

    public WebTarget path(String path) throws NullPointerException {
        return new WebTarget(this.getUriBuilder().path(path), this);
    }

    public WebTarget pathParam(String name, Object value) throws IllegalArgumentException, NullPointerException {
        WebTarget result = new WebTarget(this.getUriBuilder(), this);
        result.setPathParam(name, value);
        return result;
    }

    public WebTarget pathParams(Map<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        WebTarget result = new WebTarget(this.getUriBuilder(), this);
        result.replacePathParams(parameters);
        return result;
    }

    public WebTarget matrixParam(String name, Object ... values) throws NullPointerException {
        return new WebTarget(this.getUriBuilder().matrixParam(name, values), this);
    }

    public WebTarget queryParam(String name, Object ... values) throws NullPointerException {
        return new WebTarget(this.getUriBuilder().queryParam(name, values), this);
    }

    public WebTarget queryParams(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        UriBuilder ub = this.getUriBuilder();
        for (Map.Entry e : parameters.entrySet()) {
            ub.queryParam((String)e.getKey(), ((List)e.getValue()).toArray());
        }
        return new WebTarget(ub, this);
    }

    public JerseyInvocation.Builder request() {
        return new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot(), this.client);
    }

    public JerseyInvocation.Builder request(String ... acceptedResponseTypes) {
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot(), this.client);
        b.request().accept(acceptedResponseTypes);
        return b;
    }

    public JerseyInvocation.Builder request(MediaType ... acceptedResponseTypes) {
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot(), this.client);
        b.request().accept(acceptedResponseTypes);
        return b;
    }
}

