/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientExecutorsFactory;
import org.glassfish.jersey.client.ClientFilteringStage;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.ExceptionWrapperInterceptor;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.DefaultRespondingContext;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingBinder;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.spi.ExceptionMappers;

class ClientBinder
extends AbstractBinder {
    ClientBinder() {
    }

    protected void configure() {
        this.install(new Binder[]{new RequestScope.Binder(), new ProcessingBinder(), new ContextInjectionResolver.Binder(), new MessagingBinders.MessageBodyProviders(), new MessagingBinders.HeaderDelegateProviders(), new MessageBodyFactory.Binder(), new ExceptionMapperFactory.Binder(), new ContextResolverFactory.Binder(), new JaxrsProviders.Binder(), new ClientFilteringStage.Binder(), new ExceptionWrapperInterceptor.Binder(), new ClientExecutorsFactory.ClientExecutorBinder()});
        this.bindFactory(ConfigurationInjectionFactory.class).to(Configuration.class).to(Config.class).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<ClientConfig>>(){}).in(RequestScoped.class);
        this.bindFactory(RequestContextInjectionFactory.class).to(ClientRequest.class).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<ClientRequest>>(){}).in(RequestScoped.class);
        this.bind(DefaultRespondingContext.class).to((TypeLiteral)new TypeLiteral<ResponseProcessor.RespondingContext<ClientResponse>>(){}).in(RequestScoped.class);
        this.bind(ResponseProcessorBuilder.class).to((TypeLiteral)new TypeLiteral<ResponseProcessor.Builder<ClientResponse>>(){}).in(Singleton.class);
    }

    static class ResponseProcessorBuilder
    implements ResponseProcessor.Builder<ClientResponse> {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Provider<ResponseProcessor.RespondingContext<ClientResponse>> respondingCtxProvider;
        @Inject
        private Provider<ExceptionMappers> exceptionMappersProvider;
        @Inject
        private Provider<ClientRequest> requestContextFactory;

        public ResponseProcessor<ClientResponse> build(Future<ClientResponse> inflectedResponse, SettableFuture<ClientResponse> processedResponse, InvocationCallback<ClientResponse> callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor<ClientResponse>(callback, inflectedResponse, processedResponse, this.respondingCtxProvider, scopeInstance, this.requestScope, this.exceptionMappersProvider){

                protected ClientResponse convertResponse(Response exceptionResponse) {
                    return exceptionResponse == null ? null : new ClientResponse(exceptionResponse.getStatusInfo(), (ClientRequest)((Object)ResponseProcessorBuilder.this.requestContextFactory.get()));
                }
            };
        }
    }

    static final class RequestInvokerBuilder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder<ClientResponse> responseProcessorBuilder;
        @Inject
        private Provider<Ref<InvocationContext>> invocationContextReferenceFactory;
        @Inject
        private ExecutorsFactory<ClientRequest> executorsFactory;

        RequestInvokerBuilder() {
        }

        public RequestInvoker<ClientRequest, ClientResponse> build(Stage<ClientRequest> rootStage) {
            AsyncInflectorAdapter.Builder<ClientRequest, ClientResponse> asyncAdapterBuilder = new AsyncInflectorAdapter.Builder<ClientRequest, ClientResponse>(){

                public AsyncInflectorAdapter<ClientRequest, ClientResponse> create(Inflector<ClientRequest, ClientResponse> wrapped, InvocationCallback<ClientResponse> callback) {
                    return new AsyncInflectorAdapter<ClientRequest, ClientResponse>(wrapped, callback){

                        protected ClientResponse convertResponse(ClientRequest requestContext, Response response) {
                            return new ClientResponse(requestContext, response);
                        }
                    };
                }
            };
            return new RequestInvoker(rootStage, this.requestScope, (AsyncInflectorAdapter.Builder)asyncAdapterBuilder, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<ClientRequest> {
        @Inject
        public RequestContextInjectionFactory(Provider<Ref<ClientRequest>> referenceFactory) {
            super(referenceFactory);
        }

        @RequestScoped
        public ClientRequest provide() {
            return (ClientRequest)((Object)super.provide());
        }
    }

    private static class ConfigurationInjectionFactory
    extends ReferencingFactory<ClientConfig> {
        @Inject
        public ConfigurationInjectionFactory(Provider<Ref<ClientConfig>> referenceFactory) {
            super(referenceFactory);
        }

        @RequestScoped
        public ClientConfig provide() {
            return (ClientConfig)super.provide();
        }
    }
}

