/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Feature;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.client.ClientBinder;
import org.glassfish.jersey.client.ClientFilteringStage;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.HttpUrlConnector;
import org.glassfish.jersey.client.InboundJaxrsResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.RequestInvoker;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

public class ClientConfig
implements Configuration,
Config {
    private State state;

    public ClientConfig() {
        this.state = new State(null);
    }

    public ClientConfig(Class<?> ... providerClasses) {
        this();
        for (Class<?> providerClass : providerClasses) {
            this.state.register((Class)providerClass);
        }
    }

    public ClientConfig(Object ... providers) {
        this();
        for (Object provider : providers) {
            this.state.register(provider);
        }
    }

    ClientConfig(JerseyClient parent) {
        this.state = new State(parent);
        this.state.setConnector(new HttpUrlConnector());
    }

    ClientConfig(JerseyClient parent, Configuration that) {
        if (that instanceof ClientConfig) {
            this.state = ((ClientConfig)that).state.copy(parent);
            if (this.state.getConnector() == null) {
                this.state.setConnector(new HttpUrlConnector());
            }
        } else {
            this.state = new State(parent);
            this.state.setConnector(new HttpUrlConnector());
            this.state = this.state.setProperties(that.getProperties());
            for (Object provider : that.getProviderInstances()) {
                this.state = this.state.register(provider);
            }
            for (Class providerClass : that.getProviderClasses()) {
                this.state = this.state.register(providerClass);
            }
            for (Feature feature : that.getFeatures()) {
                this.state = this.state.enable(feature);
            }
        }
    }

    private ClientConfig(State state) {
        this.state = state;
    }

    ClientConfig snapshot() {
        this.state.markAsShared();
        return new ClientConfig(this.state);
    }

    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    public boolean isProperty(String name) {
        return this.state.isProperty(name);
    }

    public Set<Feature> getFeatures() {
        return this.state.getFeatures();
    }

    public boolean isEnabled(Class<? extends Feature> feature) {
        return this.state.isEnabled(feature);
    }

    public Set<Class<?>> getProviderClasses() {
        return this.state.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.state.getProviderInstances();
    }

    public ClientConfig update(Configuration configuration) {
        this.state = this.state.update(configuration);
        return this;
    }

    public ClientConfig register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    public ClientConfig register(Object provider) {
        this.state = provider instanceof Feature ? this.state.enable((Feature)provider) : this.state.register(provider);
        return this;
    }

    public ClientConfig setProperties(Map<String, ?> properties) {
        this.state = this.state.setProperties((Map)properties);
        return this;
    }

    public ClientConfig setProperty(String name, Object value) {
        this.state = this.state.setProperty(name, value);
        return this;
    }

    public ClientConfig connector(Inflector<ClientRequest, ClientResponse> connector) {
        this.state = this.state.setConnector(connector);
        return this;
    }

    public ClientConfig binders(Binder ... binders) {
        this.state = this.state.binders(binders);
        return this;
    }

    public Inflector<ClientRequest, ClientResponse> getConnector() {
        return this.state.getConnector();
    }

    public JerseyClient getClient() {
        return this.state.getClient();
    }

    void checkClient() throws IllegalStateException {
        if (this.getClient() == null) {
            throw new IllegalStateException("Client configuration does not contain a parent client instance.");
        }
    }

    void submit(ClientRequest requestContext, javax.ws.rs.client.InvocationCallback<Response> callback) {
        this.state.submit(requestContext, callback);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements Configuration {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private transient StateChangeStrategy strategy;
        private final Map<String, Object> properties;
        private final Map<String, Object> immutablePropertiesView;
        private final Set<Class<?>> providerClasses;
        private final Set<Class<?>> immutableClassesView;
        private final Set<Object> providerInstances;
        private final Set<Object> immutableInstancesView;
        private final Set<Feature> immutableFeatureSetView;
        private final BiMap<Class<? extends Feature>, Feature> features;
        private final List<Binder> binders;
        private final JerseyClient client;
        private Inflector<ClientRequest, ClientResponse> connector;
        private ServiceLocator locator;
        private RequestInvoker<ClientRequest, ClientResponse> invoker;
        private RequestScope requestScope;
        private volatile boolean initialized = false;
        private final Object initLock = new Object();

        State(JerseyClient client) {
            this.client = client;
            this.strategy = IDENTITY;
            this.locator = null;
            this.properties = new HashMap<String, Object>();
            this.providerClasses = new LinkedHashSet();
            this.providerInstances = new LinkedHashSet<Object>();
            this.features = HashBiMap.create();
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.immutableClassesView = Collections.unmodifiableSet(this.providerClasses);
            this.immutableInstancesView = Collections.unmodifiableSet(this.providerInstances);
            this.immutableFeatureSetView = Collections.unmodifiableSet(this.features.values());
            this.binders = Lists.newLinkedList();
            this.connector = null;
        }

        private State(JerseyClient client, State original) {
            this.client = client;
            this.strategy = IDENTITY;
            this.locator = null;
            this.properties = new HashMap<String, Object>(original.properties);
            this.providerClasses = new LinkedHashSet(original.providerClasses);
            this.providerInstances = new LinkedHashSet<Object>(original.providerInstances);
            this.features = HashBiMap.create(original.features);
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.immutableClassesView = Collections.unmodifiableSet(this.providerClasses);
            this.immutableInstancesView = Collections.unmodifiableSet(this.providerInstances);
            this.immutableFeatureSetView = Collections.unmodifiableSet(this.features.values());
            this.binders = Lists.newLinkedList(original.binders);
            this.connector = original.connector;
        }

        State copy() {
            return new State(this.client, this);
        }

        State copy(JerseyClient client) {
            return new State(client, this);
        }

        void markAsShared() {
            this.strategy = COPY_ON_CHANGE;
        }

        public Map<String, Object> getProperties() {
            return this.immutablePropertiesView;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public boolean isProperty(String name) {
            if (this.properties.containsKey(name)) {
                Object value = this.properties.get(name);
                if (value instanceof Boolean) {
                    return (Boolean)Boolean.class.cast(value);
                }
                return Boolean.parseBoolean(value.toString());
            }
            return false;
        }

        public Set<Feature> getFeatures() {
            return this.immutableFeatureSetView;
        }

        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return this.features.containsKey(featureClass);
        }

        public Set<Class<?>> getProviderClasses() {
            return this.immutableClassesView;
        }

        public Set<Object> getProviderInstances() {
            return this.immutableInstancesView;
        }

        public State update(Configuration configuration) {
            return ((ClientConfig)configuration).state.copy(this.client);
        }

        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.providerClasses.add(providerClass);
            return state;
        }

        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.providerInstances.add(provider);
            return state;
        }

        public State enable(Feature feature) {
            Class<?> featureClass = feature.getClass();
            if (this.features.containsKey(featureClass)) {
                throw new IllegalStateException(String.format("Feature [%s] has already been enabled.", featureClass));
            }
            State state = this.strategy.onChange(this);
            boolean success = feature.onEnable((Configuration)state);
            if (success) {
                state.features.put(featureClass, (Object)feature);
            }
            return state;
        }

        public State setProperties(Map<String, ?> properties) {
            State state = this.strategy.onChange(this);
            state.properties.clear();
            state.properties.putAll(properties);
            return state;
        }

        public State setProperty(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.properties.put(name, value);
            return state;
        }

        public State binders(Binder ... binders) {
            if (binders != null && binders.length > 0) {
                State state = this.strategy.onChange(this);
                Collections.addAll(state.binders, binders);
                return state;
            }
            return this;
        }

        public State setConnector(Inflector<ClientRequest, ClientResponse> connector) {
            State state = this.strategy.onChange(this);
            state.connector = connector;
            return state;
        }

        Inflector<ClientRequest, ClientResponse> getConnector() {
            return this.connector;
        }

        JerseyClient getClient() {
            return this.client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initRuntime() {
            if (this.initialized) {
                return;
            }
            Object object = this.initLock;
            synchronized (object) {
                if (this.initialized) {
                    return;
                }
                this.markAsShared();
                if (this.binders.isEmpty()) {
                    this.locator = Injections.createLocator((Binder[])new Binder[]{new ClientBinder()});
                } else {
                    Binder[] binderArray = this.binders.toArray(new Binder[this.binders.size() + 1]);
                    binderArray[binderArray.length - 1] = new ClientBinder();
                    this.locator = Injections.createLocator((Binder[])binderArray);
                }
                ProviderBinder providerBinder = new ProviderBinder(this.locator);
                providerBinder.bindClasses(this.getProviderClasses());
                providerBinder.bindInstances(this.getProviderInstances());
                this.client.addListener(new JerseyClient.LifecycleListener(){

                    @Override
                    public void onClose() {
                        ServiceLocatorFactory.getInstance().destroy(State.this.locator.getName());
                    }
                });
                RequestProcessingInitializationStage processingInitializationStage = (RequestProcessingInitializationStage)this.locator.createAndInitialize(RequestProcessingInitializationStage.class);
                ClientFilteringStage filteringStage = (ClientFilteringStage)((Object)this.locator.createAndInitialize(ClientFilteringStage.class));
                Stage rootStage = Stages.chain((Function)processingInitializationStage).to((ChainableStage)filteringStage).build(Stages.asStage(this.getConnector()));
                this.invoker = ((ClientBinder.RequestInvokerBuilder)Injections.getOrCreate((ServiceLocator)this.locator, ClientBinder.RequestInvokerBuilder.class)).build((Stage<ClientRequest>)rootStage);
                this.requestScope = (RequestScope)this.locator.getService(RequestScope.class, new Annotation[0]);
                this.initialized = true;
            }
        }

        void submit(final ClientRequest requestContext, final javax.ws.rs.client.InvocationCallback<Response> callback) {
            this.initRuntime();
            this.requestScope.runInScope(new Runnable(){

                @Override
                public void run() {
                    State.this.invoker.apply((Object)requestContext, (InvocationCallback)new InvocationCallback<ClientResponse>(){

                        public void result(ClientResponse responseContext) {
                            InboundJaxrsResponse jaxrsResponse = new InboundJaxrsResponse(responseContext);
                            callback.completed((Object)jaxrsResponse);
                        }

                        public void failure(Throwable exception) {
                            callback.failed(exception instanceof InvocationException ? (InvocationException)exception : new InvocationException(exception.getMessage(), exception));
                        }

                        public void cancelled() {
                        }

                        public void suspended(long time, TimeUnit unit, InvocationContext context) {
                        }

                        public void suspendTimeoutChanged(long time, TimeUnit unit) {
                        }

                        public void resumed() {
                        }
                    });
                }
            });
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof State)) {
                return false;
            }
            State other = (State)obj;
            return !(this != other && (this.properties != other.properties && !((Object)this.properties).equals(other.properties) || this.providerClasses != other.providerClasses && !((Object)this.providerClasses).equals(other.providerClasses) || this.providerInstances != other.providerInstances && !((Object)this.providerInstances).equals(other.providerInstances) || this.binders != other.binders && !((Object)this.binders).equals(other.binders) || this.connector != other.connector && (this.connector == null || !this.connector.equals(other.connector))));
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + ((Object)this.properties).hashCode();
            hash = 41 * hash + ((Object)this.providerClasses).hashCode();
            hash = 41 * hash + ((Object)this.providerInstances).hashCode();
            hash = 41 * hash + ((Object)this.binders).hashCode();
            hash = 41 * hash + (this.connector != null ? this.connector.hashCode() : 0);
            return hash;
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

