/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

class ClientFilteringStage
extends AbstractChainableStage<ClientRequest> {
    private final Provider<ResponseProcessor.RespondingContext<ClientResponse>> respondingContextFactory;
    private final ServiceLocator locator;

    @Inject
    ClientFilteringStage(Provider<ResponseProcessor.RespondingContext<ClientResponse>> respondingContextFactory, ServiceLocator locator) {
        this.locator = locator;
        this.respondingContextFactory = respondingContextFactory;
    }

    public Stage.Continuation<ClientRequest> apply(ClientRequest requestContext) {
        List requestFilters;
        List responseFilters = Providers.getAllProviders((ServiceLocator)this.locator, ClientResponseFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.DESCENDING));
        if (!responseFilters.isEmpty()) {
            ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push((ChainableStage)new ResponseFilterStage(responseFilters));
        }
        if (!(requestFilters = Providers.getAllProviders((ServiceLocator)this.locator, ClientRequestFilter.class, (Comparator)new PriorityComparator(PriorityComparator.Order.ASCENDING))).isEmpty()) {
            for (ClientRequestFilter filter : requestFilters) {
                try {
                    filter.filter((ClientRequestContext)requestContext);
                    final Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    return Stage.Continuation.of((Object)((Object)requestContext), (Stage)Stages.asStage((Inflector)new Inflector<ClientRequest, ClientResponse>(){

                        public ClientResponse apply(ClientRequest requestContext) {
                            return new ClientResponse(requestContext, abortResponse);
                        }
                    }));
                }
                catch (IOException ex) {
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) {
                        throw new WebApplicationException((Throwable)ex);
                    }
                    throw new WebApplicationException((Throwable)ex, abortResponse);
                }
            }
        }
        return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
    }

    static class Binder
    extends AbstractBinder {
        Binder() {
        }

        protected void configure() {
            this.bindAsContract(ClientFilteringStage.class);
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ClientResponse> {
        private final List<ClientResponseFilter> filters;

        private ResponseFilterStage(List<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        public Stage.Continuation<ClientResponse> apply(ClientResponse responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter((ClientRequestContext)responseContext.getRequestContext(), (ClientResponseContext)responseContext);
                }
            }
            catch (IOException ex) {
                throw new WebApplicationException((Throwable)ex);
            }
            return Stage.Continuation.of((Object)((Object)responseContext), (Stage)this.getDefaultNext());
        }
    }
}

