/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

public class RequestWriter {
    private static final Logger LOGGER = Logger.getLogger(RequestWriter.class.getName());

    protected RequestEntityWriter getRequestEntityWriter(ClientRequest request) {
        return new DefaultRequestEntityWriter(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRequestEntity(ClientRequest requestContext, RequestEntityWriterListener listener) throws IOException {
        this.ensureMediaType(requestContext);
        MultivaluedMap headers = requestContext.getHeaders();
        RequestEntityWriterListener sizeCallback = null;
        if (headers.containsKey((Object)"Content-Encoding")) {
            listener.onRequestEntitySize(-1L);
        } else {
            sizeCallback = listener;
        }
        MessageBodyWorkers workers = requestContext.getWorkers();
        requestContext.setStreamProvider(listener.onGetStreamProvider());
        OutputStream entityStream = null;
        try {
            entityStream = workers.writeTo(requestContext.getEntity(), requestContext.getEntity().getClass(), requestContext.getEntityType(), requestContext.getEntityAnnotations(), requestContext.getMediaType(), headers, requestContext.getPropertiesDelegate(), requestContext.getEntityStream(), (MessageBodyWorkers.MessageBodySizeCallback)sizeCallback, true);
            requestContext.setEntityStream(entityStream);
        }
        finally {
            if (entityStream != null) {
                try {
                    entityStream.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "Error closing output stream", ex);
                }
            }
        }
    }

    private void ensureMediaType(ClientRequest requestContext) {
        if (requestContext.getMediaType() == null) {
            GenericType entityType = new GenericType(requestContext.getEntityType());
            List mediaTypes = requestContext.getWorkers().getMessageBodyWriterMediaTypes(entityType.getRawType(), entityType.getType(), requestContext.getEntityAnnotations());
            requestContext.setMediaType(this.getMediaType(mediaTypes));
        }
    }

    private MediaType getMediaType(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        MediaType mediaType = mediaTypes.get(0);
        if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return mediaType;
    }

    private final class DefaultRequestEntityWriter
    implements RequestEntityWriter {
        private final ClientRequest requestContext;
        private final long size;
        private final MessageBodyWriter writer;

        public DefaultRequestEntityWriter(ClientRequest requestContext) {
            this.requestContext = requestContext;
            if (!requestContext.hasEntity()) {
                throw new IllegalArgumentException("The entity of the client request is null");
            }
            RequestWriter.this.ensureMediaType(requestContext);
            MessageBodyWorkers workers = requestContext.getWorkers();
            MediaType mediaType = requestContext.getMediaType();
            Annotation[] entityAnnotations = requestContext.getEntityAnnotations();
            Class entityRawType = requestContext.getEntityClass();
            Type entityType = requestContext.getEntityType();
            this.writer = workers.getMessageBodyWriter(entityRawType, entityType, entityAnnotations, mediaType);
            if (this.writer == null) {
                String message = "A message body writer for Java class " + entityRawType.getName() + ", and Java type " + entityType + ", and MIME media type " + mediaType + " was not found";
                LOGGER.severe(message);
                Map m = workers.getWriters(mediaType);
                LOGGER.log(Level.SEVERE, "The registered message body writers compatible with the MIME media type are:\n{0}", workers.writersToString(m));
                throw new ClientException(message);
            }
            this.size = requestContext.getHeaders().containsKey((Object)"Content-Encoding") ? -1L : this.writer.getSize(requestContext.getEntity(), entityRawType, entityType, entityAnnotations, mediaType);
        }

        @Override
        public long getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeRequestEntity(OutputStream out) throws IOException {
            try {
                GenericType entityType = new GenericType(this.requestContext.getEntityType());
                this.writer.writeTo(this.requestContext.getEntity(), entityType.getRawType(), entityType.getType(), this.requestContext.getEntityAnnotations(), this.requestContext.getMediaType(), this.requestContext.getHeaders(), out);
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }

    protected static interface RequestEntityWriter {
        public long getSize();

        public void writeRequestEntity(OutputStream var1) throws IOException;
    }

    protected static interface RequestEntityWriterListener
    extends MessageBodyWorkers.MessageBodySizeCallback {
        public OutboundMessageContext.StreamProvider onGetStreamProvider() throws IOException;
    }
}

