/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Function;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.client.ClientException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientAsyncExecutorsFactory;
import org.glassfish.jersey.client.ClientFilteringStages;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.client.ResponseCallback;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

class Runtime {
    private final Stage<ClientRequest> requestProcessingRoot;
    private final Stage<ClientResponse> responseProcessingRoot;
    private final Connector connector;
    private final RequestScope requestScope;
    private final ClientAsyncExecutorsFactory asyncExecutorsFactory;

    public Runtime(Connector connector, ServiceLocator locator) {
        Stage.Builder requestingChainBuilder = Stages.chain((Function)((Function)locator.createAndInitialize(RequestProcessingInitializationStage.class)));
        ChainableStage<ClientRequest> requestFilteringStage = ClientFilteringStages.createRequestFilteringStage(locator);
        this.requestProcessingRoot = requestFilteringStage != null ? requestingChainBuilder.build(requestFilteringStage) : requestingChainBuilder.build();
        ChainableStage responseFilteringStage = ClientFilteringStages.createResponseFilteringStage(locator);
        this.responseProcessingRoot = responseFilteringStage != null ? responseFilteringStage : Stages.identity();
        this.connector = connector;
        this.requestScope = (RequestScope)locator.getService(RequestScope.class, new Annotation[0]);
        this.asyncExecutorsFactory = new ClientAsyncExecutorsFactory(locator);
    }

    public void submit(final ClientRequest request, final ResponseCallback callback) {
        this.submit(this.asyncExecutorsFactory.getRequestingExecutor(request), new Runnable(){

            @Override
            public void run() {
                Stage.Continuation continuation = Runtime.this.process((Object)request, Runtime.this.requestProcessingRoot);
                final RequestScope.Instance currentScopeInstance = Runtime.this.requestScope.referenceCurrent();
                Runtime.this.connector.apply((ClientRequest)((Object)continuation.result()), new AsyncConnectorCallback(){

                    @Override
                    public void response(final ClientResponse response) {
                        Runtime.this.submit(Runtime.this.asyncExecutorsFactory.getRespondingExecutor(request), currentScopeInstance, new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    callback.completed((ClientResponse)((Object)Runtime.this.process((Object)response, Runtime.this.responseProcessingRoot).result()), Runtime.this.requestScope);
                                }
                                finally {
                                    currentScopeInstance.release();
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failure(Throwable failure) {
                        if (failure instanceof AbortException) {
                            this.response(((AbortException)((Object)failure)).getAbortResponse());
                        }
                        try {
                            callback.failed(failure instanceof ClientException ? (ClientException)failure : new ClientException(failure));
                        }
                        finally {
                            currentScopeInstance.release();
                        }
                    }
                });
            }
        });
    }

    private Future<?> submit(ExecutorService executor, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                Runtime.this.requestScope.runInScope(task);
            }
        });
    }

    private Future<?> submit(ExecutorService executor, final RequestScope.Instance scopeInstance, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                Runtime.this.requestScope.runInScope(scopeInstance, task);
            }
        });
    }

    public ClientResponse invoke(ClientRequest request) throws ClientException {
        try {
            ClientResponse response;
            try {
                Stage.Continuation<ClientRequest> continuation = this.process(request, this.requestProcessingRoot);
                response = this.connector.apply((ClientRequest)((Object)continuation.result()));
            }
            catch (AbortException aborted) {
                response = aborted.getAbortResponse();
            }
            return (ClientResponse)((Object)this.process(response, this.responseProcessingRoot).result());
        }
        catch (ClientException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new ClientException(t.getMessage(), t);
        }
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public void close() {
        this.connector.close();
    }

    private <DATA> Stage.Continuation<DATA> process(DATA data, Stage<DATA> processingRoot) {
        Stage currentStage;
        Stage.Continuation continuation = Stage.Continuation.of(data, processingRoot);
        while ((currentStage = continuation.next()) != null) {
            continuation = currentStage.apply(continuation.result());
        }
        return continuation;
    }
}

