/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyInvocation;

public class WebTarget
implements javax.ws.rs.client.WebTarget {
    private final ClientConfig configuration;
    private final UriBuilder targetUri;
    private final Map<String, Object> pathParams;

    WebTarget(String uri, JerseyClient parent) {
        this(UriBuilder.fromUri((String)uri), null, parent.configuration().snapshot());
    }

    WebTarget(URI uri, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)uri), null, parent.configuration().snapshot());
    }

    WebTarget(UriBuilder uriBuilder, JerseyClient parent) {
        this(uriBuilder.clone(), null, parent.configuration().snapshot());
    }

    WebTarget(Link link, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)link.getUri()), null, parent.configuration().snapshot());
    }

    protected WebTarget(UriBuilder uriBuilder, WebTarget that) {
        this(uriBuilder, that.pathParams, that.configuration.snapshot());
    }

    protected WebTarget(UriBuilder uriBuilder, Map<String, Object> pathParams, ClientConfig clientConfig) {
        clientConfig.checkClient();
        this.targetUri = uriBuilder;
        this.pathParams = pathParams != null ? Maps.newHashMap(pathParams) : Maps.newHashMap();
        this.configuration = clientConfig;
    }

    protected final void setPathParam(String name, Object value) {
        if (value == null) {
            this.pathParams.remove(name);
        } else {
            this.pathParams.put(name, value);
        }
    }

    protected final void replacePathParams(Map<String, Object> valueMap, boolean discardExisting) {
        if (valueMap == null) {
            throw new NullPointerException("New parameter value map must not be null.");
        }
        if (discardExisting) {
            this.pathParams.clear();
        }
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            this.setPathParam(entry.getKey(), entry.getValue());
        }
    }

    public URI getUri() {
        this.configuration.getClient().checkNotClosed();
        try {
            return this.targetUri.buildFromMap(this.pathParams);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    private void checkNotClosed() {
        this.configuration.getClient().checkNotClosed();
    }

    public UriBuilder getUriBuilder() {
        this.checkNotClosed();
        return this.targetUri.clone();
    }

    public ClientConfig configuration() {
        this.checkNotClosed();
        return this.configuration;
    }

    public WebTarget path(String path) throws NullPointerException {
        this.checkNotClosed();
        return new WebTarget(this.getUriBuilder().path(path), this);
    }

    public WebTarget pathParam(String name, Object value) throws NullPointerException {
        this.checkNotClosed();
        WebTarget result = new WebTarget(this.getUriBuilder(), this);
        result.setPathParam(name, value);
        return result;
    }

    public WebTarget pathParams(Map<String, Object> parameters) throws NullPointerException {
        this.checkNotClosed();
        WebTarget result = new WebTarget(this.getUriBuilder(), this);
        result.replacePathParams(parameters, false);
        return result;
    }

    public WebTarget matrixParam(String name, Object ... values) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"Matrix parameter name must not be 'null'.");
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return new WebTarget(this.getUriBuilder().replaceMatrixParam(name, (Object[])null), this);
        }
        WebTarget.checkForNullValues(name, values);
        return new WebTarget(this.getUriBuilder().matrixParam(name, values), this);
    }

    public WebTarget queryParam(String name, Object ... values) throws NullPointerException {
        this.checkNotClosed();
        return new WebTarget(WebTarget.setQueryParam(this.getUriBuilder(), name, values), this);
    }

    private static UriBuilder setQueryParam(UriBuilder uriBuilder, String name, Object[] values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return uriBuilder.replaceQueryParam(name, (Object[])null);
        }
        WebTarget.checkForNullValues(name, values);
        return uriBuilder.queryParam(name, values);
    }

    private static void checkForNullValues(String name, Object[] values) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            indexes.add(i);
        }
        int failedIndexCount = indexes.size();
        if (failedIndexCount > 0) {
            String indexTxt;
            String valueTxt;
            if (failedIndexCount == 1) {
                valueTxt = "value";
                indexTxt = "index";
            } else {
                valueTxt = "values";
                indexTxt = "indexes";
            }
            throw new NullPointerException(String.format("'null' %s detected for parameter '%s' on %s : %s", valueTxt, name, indexTxt, ((Object)indexes).toString()));
        }
    }

    public WebTarget queryParams(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        this.checkNotClosed();
        UriBuilder ub = this.getUriBuilder();
        for (Map.Entry e : parameters.entrySet()) {
            ub = WebTarget.setQueryParam(ub, (String)e.getKey(), ((List)e.getValue()).toArray());
        }
        return new WebTarget(ub, this);
    }

    public JerseyInvocation.Builder request() {
        this.checkNotClosed();
        return new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot());
    }

    public JerseyInvocation.Builder request(String ... acceptedResponseTypes) {
        this.checkNotClosed();
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot());
        b.request().accept(acceptedResponseTypes);
        return b;
    }

    public JerseyInvocation.Builder request(MediaType ... acceptedResponseTypes) {
        this.checkNotClosed();
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot());
        b.request().accept(acceptedResponseTypes);
        return b;
    }
}

