/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.LinkedList;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyInvocation;

public class JerseyWebTarget
implements WebTarget {
    private final ClientConfig configuration;
    private final UriBuilder targetUri;

    JerseyWebTarget(String uri, JerseyClient parent) {
        this(UriBuilder.fromUri((String)uri), parent.configuration().snapshot());
    }

    JerseyWebTarget(URI uri, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)uri), parent.configuration().snapshot());
    }

    JerseyWebTarget(UriBuilder uriBuilder, JerseyClient parent) {
        this(uriBuilder.clone(), parent.configuration().snapshot());
    }

    JerseyWebTarget(Link link, JerseyClient parent) {
        this(UriBuilder.fromUri((URI)link.getUri()), parent.configuration().snapshot());
    }

    protected JerseyWebTarget(UriBuilder uriBuilder, JerseyWebTarget that) {
        this(uriBuilder, that.configuration.snapshot());
    }

    protected JerseyWebTarget(UriBuilder uriBuilder, ClientConfig clientConfig) {
        clientConfig.checkClient();
        this.targetUri = uriBuilder;
        this.configuration = clientConfig;
    }

    public URI getUri() {
        this.configuration.getClient().checkNotClosed();
        try {
            return this.targetUri.build(new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    private void checkNotClosed() {
        this.configuration.getClient().checkNotClosed();
    }

    public UriBuilder getUriBuilder() {
        this.checkNotClosed();
        return this.targetUri.clone();
    }

    public ClientConfig configuration() {
        this.checkNotClosed();
        return this.configuration;
    }

    public JerseyWebTarget path(String path) throws NullPointerException {
        this.checkNotClosed();
        return new JerseyWebTarget(this.getUriBuilder().path(path), this);
    }

    public JerseyWebTarget matrixParam(String name, Object ... values) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"Matrix parameter name must not be 'null'.");
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return new JerseyWebTarget(this.getUriBuilder().replaceMatrixParam(name, (Object[])null), this);
        }
        JerseyWebTarget.checkForNullValues(name, values);
        return new JerseyWebTarget(this.getUriBuilder().matrixParam(name, values), this);
    }

    public JerseyWebTarget queryParam(String name, Object ... values) throws NullPointerException {
        this.checkNotClosed();
        return new JerseyWebTarget(JerseyWebTarget.setQueryParam(this.getUriBuilder(), name, values), this);
    }

    private static UriBuilder setQueryParam(UriBuilder uriBuilder, String name, Object[] values) {
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            return uriBuilder.replaceQueryParam(name, (Object[])null);
        }
        JerseyWebTarget.checkForNullValues(name, values);
        return uriBuilder.queryParam(name, values);
    }

    private static void checkForNullValues(String name, Object[] values) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            indexes.add(i);
        }
        int failedIndexCount = indexes.size();
        if (failedIndexCount > 0) {
            String indexTxt;
            String valueTxt;
            if (failedIndexCount == 1) {
                valueTxt = "value";
                indexTxt = "index";
            } else {
                valueTxt = "values";
                indexTxt = "indexes";
            }
            throw new NullPointerException(String.format("'null' %s detected for parameter '%s' on %s : %s", valueTxt, name, indexTxt, ((Object)indexes).toString()));
        }
    }

    public JerseyInvocation.Builder request() {
        this.checkNotClosed();
        return new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot());
    }

    public JerseyInvocation.Builder request(String ... acceptedResponseTypes) {
        this.checkNotClosed();
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot());
        b.request().accept(acceptedResponseTypes);
        return b;
    }

    public JerseyInvocation.Builder request(MediaType ... acceptedResponseTypes) {
        this.checkNotClosed();
        JerseyInvocation.Builder b = new JerseyInvocation.Builder(this.getUri(), this.configuration.snapshot());
        b.request().accept(acceptedResponseTypes);
        return b;
    }

    public JerseyWebTarget resolveTemplate(String name, Object value) throws NullPointerException {
        return this.resolveTemplate(name, value, true);
    }

    public JerseyWebTarget resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"name is 'null'.");
        Preconditions.checkNotNull((Object)name, (Object)"value is 'null'.");
        return new JerseyWebTarget(this.getUriBuilder().resolveTemplate(name, value, encodeSlashInPath), this);
    }

    public JerseyWebTarget resolveTemplateFromEncoded(String name, Object value) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)name, (Object)"name is 'null'.");
        Preconditions.checkNotNull((Object)name, (Object)"value is 'null'.");
        return new JerseyWebTarget(this.getUriBuilder().resolveTemplateFromEncoded(name, value), this);
    }

    public JerseyWebTarget resolveTemplates(Map<String, Object> templateValues) throws NullPointerException {
        return this.resolveTemplates((Map)templateValues, true);
    }

    public JerseyWebTarget resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull(templateValues, (Object)"templateValues is 'null'.");
        return new JerseyWebTarget(this.getUriBuilder().resolveTemplates(templateValues, encodeSlashInPath), this);
    }

    public JerseyWebTarget resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull(templateValues, (Object)"templateValues is 'null'.");
        return new JerseyWebTarget(this.getUriBuilder().resolveTemplatesFromEncoded(templateValues), this);
    }
}

