/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.jersey.Config;
import org.glassfish.jersey.client.ClientBinder;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.client.HttpUrlConnector;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ProviderBinder;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;

public class ClientConfig
implements Configuration,
Config,
Configurable {
    private State state;

    public ClientConfig() {
        this.state = new State(null);
    }

    public ClientConfig(Class<?> ... providerClasses) {
        this();
        for (Class<?> providerClass : providerClasses) {
            this.state.register((Class)providerClass);
        }
    }

    public ClientConfig(Object ... providers) {
        this();
        for (Object provider : providers) {
            this.state.register(provider);
        }
    }

    ClientConfig(JerseyClient parent) {
        this.state = new State(parent);
        this.state.setConnector(new HttpUrlConnector());
    }

    ClientConfig(JerseyClient parent, Configurable that) {
        if (that instanceof ClientConfig) {
            this.state = ((ClientConfig)that).state.copy(parent);
            if (this.state.getConnector() == null) {
                this.state.setConnector(new HttpUrlConnector());
            }
        } else {
            this.state = new State(parent);
            this.state.setConnector(new HttpUrlConnector());
            this.state = this.state.setProperties(that.getProperties());
            for (Object provider : that.getProviderInstances()) {
                this.state = this.state.register(provider);
            }
            for (Class providerClass : that.getProviderClasses()) {
                this.state = this.state.register(providerClass);
            }
            for (Feature feature : that.getFeatures()) {
                this.state = this.state.enable(feature);
            }
        }
    }

    private ClientConfig(State state) {
        this.state = state;
    }

    ClientConfig snapshot() {
        this.state.markAsShared();
        return new ClientConfig(this.state);
    }

    public Map<String, Object> getProperties() {
        return this.state.getProperties();
    }

    public Object getProperty(String name) {
        return this.state.getProperty(name);
    }

    public boolean isProperty(String name) {
        return this.state.isProperty(name);
    }

    public Set<Feature> getFeatures() {
        return this.state.getFeatures();
    }

    public boolean isEnabled(Class<? extends Feature> feature) {
        return this.state.isEnabled(feature);
    }

    public Set<Class<?>> getProviderClasses() {
        return this.state.getProviderClasses();
    }

    public Set<Object> getProviderInstances() {
        return this.state.getProviderInstances();
    }

    public ClientConfig updateFrom(Configurable configuration) {
        this.state = this.state.updateFrom(configuration);
        return this;
    }

    public ClientConfig register(Class<?> providerClass) {
        this.state = this.state.register((Class)providerClass);
        return this;
    }

    public ClientConfig register(Object provider) {
        this.state = provider instanceof Feature ? this.state.enable((Feature)provider) : this.state.register(provider);
        return this;
    }

    public ClientConfig register(Class<?> providerClass, int bindingPriority) {
        this.state = this.state.register((Class)providerClass, bindingPriority);
        return this;
    }

    public <T> ClientConfig register(Class<T> providerClass, Class<? super T> ... contracts) {
        this.state = this.state.register((Class)providerClass, (Class[])contracts);
        return this;
    }

    public <T> ClientConfig register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
        this.state = this.state.register((Class)providerClass, bindingPriority, (Class[])contracts);
        return this;
    }

    public ClientConfig register(Object provider, int bindingPriority) {
        this.state = this.state.register(provider, bindingPriority);
        return this;
    }

    public <T> ClientConfig register(Object provider, Class<? super T> ... contracts) {
        this.state = this.state.register(provider, (Class[])contracts);
        return this;
    }

    public <T> ClientConfig register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
        this.state = this.state.register(provider, bindingPriority, (Class[])contracts);
        return this;
    }

    public ClientConfig setProperties(Map<String, ?> properties) {
        this.state = this.state.setProperties((Map)properties);
        return this;
    }

    public ClientConfig setProperty(String name, Object value) {
        this.state = this.state.setProperty(name, value);
        return this;
    }

    public ClientConfig connector(Connector connector) {
        this.state = this.state.setConnector(connector);
        return this;
    }

    public ClientConfig binders(Binder ... binders) {
        this.state = this.state.binders(binders);
        return this;
    }

    public Connector getConnector() {
        return this.state.getConnector();
    }

    ClientRuntime getRuntime() {
        return (ClientRuntime)this.state.runtime.get();
    }

    public JerseyClient getClient() {
        return this.state.getClient();
    }

    void checkClient() throws IllegalStateException {
        if (this.getClient() == null) {
            throw new IllegalStateException("Client configuration does not contain a parent client instance.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientConfig other = (ClientConfig)obj;
        return this.state == other.state || this.state != null && this.state.equals(other.state);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.state != null ? this.state.hashCode() : 0);
        return hash;
    }

    private static class State
    implements Configuration,
    Config,
    Configurable {
        private static final StateChangeStrategy IDENTITY = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state;
            }
        };
        private static final StateChangeStrategy COPY_ON_CHANGE = new StateChangeStrategy(){

            @Override
            public State onChange(State state) {
                return state.copy();
            }
        };
        private volatile StateChangeStrategy strategy;
        private final Map<String, Object> properties;
        private final Map<String, Object> immutablePropertiesView;
        private final Set<Class<?>> providerClasses;
        private final Set<Class<?>> immutableClassesView;
        private final Set<Object> providerInstances;
        private final Set<Object> immutableInstancesView;
        private final Set<Feature> immutableFeatureSetView;
        private final BiMap<Class<? extends Feature>, Feature> features;
        private final List<Binder> binders;
        private final JerseyClient client;
        private Connector connector;
        private Value<ClientRuntime> runtime = Values.lazy((Value)new Value<ClientRuntime>(){

            public ClientRuntime get() {
                return State.this.initRuntime();
            }
        });

        State(JerseyClient client) {
            this.client = client;
            this.strategy = IDENTITY;
            this.properties = new HashMap<String, Object>();
            this.providerClasses = new LinkedHashSet();
            this.providerInstances = new LinkedHashSet<Object>();
            this.features = HashBiMap.create();
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.immutableClassesView = Collections.unmodifiableSet(this.providerClasses);
            this.immutableInstancesView = Collections.unmodifiableSet(this.providerInstances);
            this.immutableFeatureSetView = Collections.unmodifiableSet(this.features.values());
            this.binders = Lists.newLinkedList();
            this.connector = null;
        }

        private State(JerseyClient client, State original) {
            this.client = client;
            this.strategy = IDENTITY;
            this.properties = new HashMap<String, Object>(original.properties);
            this.providerClasses = new LinkedHashSet(original.providerClasses);
            this.providerInstances = new LinkedHashSet<Object>(original.providerInstances);
            this.features = HashBiMap.create(original.features);
            this.immutablePropertiesView = Collections.unmodifiableMap(this.properties);
            this.immutableClassesView = Collections.unmodifiableSet(this.providerClasses);
            this.immutableInstancesView = Collections.unmodifiableSet(this.providerInstances);
            this.immutableFeatureSetView = Collections.unmodifiableSet(this.features.values());
            this.binders = Lists.newLinkedList(original.binders);
            this.connector = original.connector;
        }

        State copy() {
            return new State(this.client, this);
        }

        State copy(JerseyClient client) {
            return new State(client, this);
        }

        void markAsShared() {
            this.strategy = COPY_ON_CHANGE;
        }

        public Map<String, Object> getProperties() {
            return this.immutablePropertiesView;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public boolean isProperty(String name) {
            if (this.properties.containsKey(name)) {
                Object value = this.properties.get(name);
                if (value instanceof Boolean) {
                    return (Boolean)Boolean.class.cast(value);
                }
                return Boolean.parseBoolean(value.toString());
            }
            return false;
        }

        public Set<Feature> getFeatures() {
            return this.immutableFeatureSetView;
        }

        public boolean isEnabled(Class<? extends Feature> featureClass) {
            return this.features.containsKey(featureClass);
        }

        public Set<Class<?>> getProviderClasses() {
            return this.immutableClassesView;
        }

        public Set<Object> getProviderInstances() {
            return this.immutableInstancesView;
        }

        public State updateFrom(Configurable configuration) {
            return ((ClientConfig)configuration).state.copy(this.client);
        }

        public State register(Class<?> providerClass) {
            State state = this.strategy.onChange(this);
            state.providerClasses.add(providerClass);
            return state;
        }

        public State register(Object provider) {
            State state = this.strategy.onChange(this);
            state.providerInstances.add(provider);
            return state;
        }

        public State register(Class<?> providerClass, int bindingPriority) {
            State state = this.strategy.onChange(this);
            return state;
        }

        public <T> State register(Class<T> providerClass, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            return state;
        }

        public <T> State register(Class<T> providerClass, int bindingPriority, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            return state;
        }

        public State register(Object provider, int bindingPriority) {
            State state = this.strategy.onChange(this);
            return state;
        }

        public <T> State register(Object provider, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            return state;
        }

        public <T> State register(Object provider, int bindingPriority, Class<? super T> ... contracts) {
            State state = this.strategy.onChange(this);
            return state;
        }

        public State enable(Feature feature) {
            Class<?> featureClass = feature.getClass();
            if (this.features.containsKey(featureClass)) {
                throw new IllegalStateException(String.format("Feature [%s] has already been enabled.", featureClass));
            }
            State state = this.strategy.onChange(this);
            boolean success = feature.configure((Configurable)state);
            if (success) {
                state.features.put(featureClass, (Object)feature);
            }
            return state;
        }

        public State setProperties(Map<String, ?> properties) {
            State state = this.strategy.onChange(this);
            state.properties.clear();
            state.properties.putAll(properties);
            return state;
        }

        public State setProperty(String name, Object value) {
            State state = this.strategy.onChange(this);
            state.properties.put(name, value);
            return state;
        }

        public State binders(Binder ... binders) {
            if (binders != null && binders.length > 0) {
                State state = this.strategy.onChange(this);
                Collections.addAll(state.binders, binders);
                return state;
            }
            return this;
        }

        public State setConnector(Connector connector) {
            State state = this.strategy.onChange(this);
            state.connector = connector;
            return state;
        }

        Connector getConnector() {
            return this.connector;
        }

        JerseyClient getClient() {
            return this.client;
        }

        private ClientRuntime initRuntime() {
            ServiceLocator locator;
            this.markAsShared();
            AbstractBinder configBinder = new AbstractBinder(){

                protected void configure() {
                    this.bind(State.this).to(Configuration.class).to(Config.class);
                }
            };
            if (this.binders.isEmpty()) {
                locator = Injections.createLocator((Binder[])new Binder[]{configBinder, new ClientBinder()});
            } else {
                ArrayList<Object> allBinders = new ArrayList<Object>(this.binders.size() + 2);
                allBinders.add(configBinder);
                allBinders.add((Object)new ClientBinder());
                allBinders.addAll(this.binders);
                locator = Injections.createLocator((Binder[])allBinders.toArray(new Binder[allBinders.size()]));
            }
            ProviderBinder providerBinder = new ProviderBinder(locator);
            providerBinder.bindClasses(this.getProviderClasses());
            providerBinder.bindInstances(this.getProviderInstances());
            final ClientRuntime runtime = new ClientRuntime(this.connector, locator);
            this.client.addListener(new JerseyClient.LifecycleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onClose() {
                    try {
                        runtime.close();
                    }
                    finally {
                        ServiceLocatorFactory.getInstance().destroy(locator.getName());
                    }
                }
            });
            return runtime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof State)) {
                return false;
            }
            State other = (State)obj;
            return !(this != other && (this.properties != other.properties && !((Object)this.properties).equals(other.properties) || this.providerClasses != other.providerClasses && !((Object)this.providerClasses).equals(other.providerClasses) || this.providerInstances != other.providerInstances && !((Object)this.providerInstances).equals(other.providerInstances) || this.binders != other.binders && !((Object)this.binders).equals(other.binders) || this.connector != other.connector && (this.connector == null || !this.connector.equals(other.connector))));
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + ((Object)this.properties).hashCode();
            hash = 41 * hash + ((Object)this.providerClasses).hashCode();
            hash = 41 * hash + ((Object)this.providerInstances).hashCode();
            hash = 41 * hash + ((Object)this.binders).hashCode();
            hash = 41 * hash + (this.connector != null ? this.connector.hashCode() : 0);
            return hash;
        }

        private static interface StateChangeStrategy {
            public State onChange(State var1);
        }
    }
}

