/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestWriter;
import org.glassfish.jersey.client.SslConfig;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class HttpUrlConnector
extends RequestWriter
implements Connector {
    private final ConnectionFactory connectionFactory;

    public HttpUrlConnector() {
        this.connectionFactory = null;
    }

    public HttpUrlConnector(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    private static InputStream getInputStream(HttpURLConnection uc) throws IOException {
        if (uc.getResponseCode() < 300) {
            return uc.getInputStream();
        }
        InputStream ein = uc.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public ClientResponse apply(ClientRequest request) {
        try {
            return this._apply(request);
        }
        catch (IOException ex) {
            throw new ClientException((Throwable)ex);
        }
    }

    @Override
    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(HttpUrlConnector.this._apply(request));
                }
                catch (IOException ex) {
                    callback.failure(new ClientException((Throwable)ex));
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    @Override
    public void close() {
    }

    private ClientResponse _apply(final ClientRequest request) throws IOException {
        Object entity;
        Map<String, Object> configurationProperties = request.getConfiguration().getProperties();
        URL endpointUrl = request.getUri().toURL();
        final HttpURLConnection uc = this.connectionFactory == null ? (HttpURLConnection)endpointUrl.openConnection() : this.connectionFactory.getConnection(endpointUrl);
        uc.setDoInput(true);
        String httpMethod = request.getMethod();
        if (((Boolean)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)false)).booleanValue()) {
            HttpUrlConnector.setRequestMethodViaJreBugWorkaround(uc, httpMethod);
        } else {
            uc.setRequestMethod(httpMethod);
        }
        uc.setInstanceFollowRedirects((Boolean)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.followRedirects", (Object)true));
        uc.setConnectTimeout((Integer)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.connectTimeout", (Object)0));
        uc.setReadTimeout((Integer)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.readTimeout", (Object)0));
        if (uc instanceof HttpsURLConnection) {
            HttpsURLConnection suc = (HttpsURLConnection)uc;
            SslConfig sslConfig = (SslConfig)PropertiesHelper.getValue(configurationProperties, (String)"jersey.config.client.ssl.sslConfig", SslConfig.class);
            if (sslConfig.isHostnameVerifierSet()) {
                suc.setHostnameVerifier(sslConfig.getHostnameVerifier());
            }
            suc.setSSLSocketFactory(sslConfig.getSSLContext().getSocketFactory());
        }
        if ((entity = request.getEntity()) != null) {
            Logger logger;
            uc.setDoOutput(true);
            if (httpMethod.equalsIgnoreCase("GET") && (logger = Logger.getLogger(HttpUrlConnector.class.getName())).isLoggable(Level.INFO)) {
                logger.log(Level.INFO, LocalizationMessages.HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
            }
            this.writeRequestEntity(request, new RequestWriter.RequestEntityWriterListener(){

                public void onRequestEntitySize(long size) {
                    if (size == -1L || size < Integer.MAX_VALUE) {
                        // empty if block
                    }
                }

                @Override
                public OutboundMessageContext.StreamProvider onGetStreamProvider() throws IOException {
                    return new OutboundMessageContext.StreamProvider(){

                        public OutputStream getOutputStream() throws IOException {
                            return uc.getOutputStream();
                        }

                        public void commit() throws IOException {
                            HttpUrlConnector.this.writeOutBoundHeaders((MultivaluedMap<String, String>)request.getStringHeaders(), uc);
                        }
                    };
                }
            });
        } else {
            this.writeOutBoundHeaders((MultivaluedMap<String, String>)request.getStringHeaders(), uc);
        }
        ClientResponse responseContext = new ClientResponse(Statuses.from((int)uc.getResponseCode()), request);
        responseContext.setEntityStream(HttpUrlConnector.getInputStream(uc));
        responseContext.headers(Maps.filterKeys(uc.getHeaderFields(), (Predicate)Predicates.notNull()));
        return responseContext;
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, String> headers, HttpURLConnection uc) {
        for (Map.Entry header : headers.entrySet()) {
            List headerValues = (List)header.getValue();
            if (headerValues.size() == 1) {
                uc.setRequestProperty((String)header.getKey(), (String)headerValues.get(0));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (String value : headerValues) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append((Object)value);
            }
            uc.setRequestProperty((String)header.getKey(), b.toString());
        }
    }

    private static void setRequestMethodViaJreBugWorkaround(HttpURLConnection httpURLConnection, String method) {
        try {
            httpURLConnection.setRequestMethod(method);
        }
        catch (ProtocolException pe) {
            try {
                Class<?> httpURLConnectionClass = httpURLConnection.getClass();
                Field methodField = httpURLConnectionClass.getSuperclass().getDeclaredField("method");
                methodField.setAccessible(true);
                methodField.set(httpURLConnection, method);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getName() {
        return "HttpUrlConnection " + System.getProperty("java.version");
    }

    public static interface ConnectionFactory {
        public HttpURLConnection getConnection(URL var1) throws IOException;
    }
}

