/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientRuntime;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

public class ClientRequest
extends OutboundMessageContext
implements ClientRequestContext {
    private final ClientConfig configuration;
    private final PropertiesDelegate propertiesDelegate;
    private URI requestUri;
    private String httpMethod;
    private Response abortResponse;
    private MessageBodyWorkers workers;
    private boolean asynchronous;

    public ClientRequest(URI requestUri, ClientConfig configuration, PropertiesDelegate propertiesDelegate) {
        configuration.checkClient();
        this.requestUri = requestUri;
        this.configuration = configuration;
        this.propertiesDelegate = propertiesDelegate;
    }

    public ClientRequest(ClientRequest original) {
        super((OutboundMessageContext)original);
        this.requestUri = original.requestUri;
        this.httpMethod = original.httpMethod;
        this.workers = original.workers;
        this.configuration = original.configuration.snapshot();
        this.asynchronous = original.isAsynchronous();
        this.propertiesDelegate = new MapPropertiesDelegate(original.propertiesDelegate);
    }

    public Object getProperty(String name) {
        return this.propertiesDelegate.getProperty(name);
    }

    public Enumeration<String> getPropertyNames() {
        return this.propertiesDelegate.getPropertyNames();
    }

    public void setProperty(String name, Object object) {
        this.propertiesDelegate.setProperty(name, object);
    }

    public void removeProperty(String name) {
        this.propertiesDelegate.removeProperty(name);
    }

    PropertiesDelegate getPropertiesDelegate() {
        return this.propertiesDelegate;
    }

    ClientRuntime getClientRuntime() {
        return this.configuration.getRuntime();
    }

    public URI getUri() {
        return this.requestUri;
    }

    public void setUri(URI uri) {
        this.requestUri = uri;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public void setMethod(String method) {
        this.httpMethod = method;
    }

    public JerseyClient getClient() {
        return this.configuration.getClient();
    }

    public void abortWith(Response response) {
        this.abortResponse = response;
    }

    public Response getAbortResponse() {
        return this.abortResponse;
    }

    public Configuration getConfiguration() {
        return this.configuration.getRuntimeConfig() != null ? this.configuration.getRuntimeConfig() : this.configuration;
    }

    public Map<String, Cookie> getCookies() {
        return super.getRequestCookies();
    }

    public MessageBodyWorkers getWorkers() {
        return this.workers;
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    public void accept(MediaType ... types) {
        this.getHeaders().addAll((Object)"Accept", (Object[])types);
    }

    public void accept(String ... types) {
        this.getHeaders().addAll((Object)"Accept", (Object[])types);
    }

    public void acceptLanguage(Locale ... locales) {
        this.getHeaders().addAll((Object)"Accept-Language", (Object[])locales);
    }

    public void acceptLanguage(String ... locales) {
        this.getHeaders().addAll((Object)"Accept-Language", (Object[])locales);
    }

    public void cookie(Cookie cookie) {
        this.getHeaders().add((Object)"Cookie", (Object)cookie);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.getHeaders().add((Object)"Cache-Control", (Object)cacheControl);
    }

    public void encoding(String encoding) {
        if (encoding == null) {
            this.getHeaders().remove((Object)"Content-Encoding");
        } else {
            this.getHeaders().putSingle((Object)"Content-Encoding", (Object)encoding);
        }
    }

    public void language(String language) {
        if (language == null) {
            this.getHeaders().remove((Object)"Content-Language");
        } else {
            this.getHeaders().putSingle((Object)"Content-Language", (Object)language);
        }
    }

    public void language(Locale language) {
        if (language == null) {
            this.getHeaders().remove((Object)"Content-Language");
        } else {
            this.getHeaders().putSingle((Object)"Content-Language", (Object)language);
        }
    }

    public void type(MediaType type) {
        this.setMediaType(type);
    }

    public void type(String type) {
        this.type(type == null ? null : MediaType.valueOf((String)type));
    }

    public void variant(Variant variant) {
        if (variant == null) {
            this.type((MediaType)null);
            this.language((String)null);
            this.encoding(null);
        } else {
            this.type(variant.getMediaType());
            this.language(variant.getLanguage());
            this.encoding(variant.getEncoding());
        }
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    void setAsynchronous(boolean async) {
        this.asynchronous = async;
    }
}

